/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.File;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.StringScriptSource;
import org.gradle.groovy.scripts.UriScriptSource;
import org.gradle.internal.reflect.Instantiator;

public class ProjectFactory
implements IProjectFactory {
    private final Instantiator instantiator;

    public ProjectFactory(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public DefaultProject createProject(ProjectDescriptor projectDescriptor, ProjectInternal parent, GradleInternal gradle) {
        File buildFile = projectDescriptor.getBuildFile();
        ScriptSource source = !buildFile.exists() ? new StringScriptSource("empty build file", "") : new UriScriptSource("build file", buildFile);
        DefaultProject project = (DefaultProject)this.instantiator.newInstance(DefaultProject.class, new Object[]{projectDescriptor.getName(), parent, projectDescriptor.getProjectDir(), source, gradle, gradle.getServiceRegistryFactory()});
        if (parent != null) {
            parent.addChildProject(project);
        }
        gradle.getProjectRegistry().addProject(project);
        return project;
    }
}

