/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.DefaultScriptHandler;
import org.gradle.api.internal.initialization.NoClassLoaderUpdateScriptHandler;
import org.gradle.api.internal.initialization.ScriptCompileScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.groovy.scripts.ScriptSource;

public class DefaultScriptHandlerFactory
implements ScriptHandlerFactory {
    private final DependencyManagementServices dependencyManagementServices;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final Map<Collection<Object>, DefaultScriptHandler> classLoaderCache = new HashMap<Collection<Object>, DefaultScriptHandler>();
    private final FileResolver fileResolver;
    private final ProjectFinder projectFinder = new ProjectFinder(){

        public ProjectInternal getProject(String path) {
            throw new UnknownProjectException("Cannot use project dependencies in a script classpath definition.");
        }
    };

    public DefaultScriptHandlerFactory(DependencyManagementServices dependencyManagementServices, FileResolver fileResolver, DependencyMetaDataProvider dependencyMetaDataProvider) {
        this.dependencyManagementServices = dependencyManagementServices;
        this.fileResolver = fileResolver;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
    }

    public ScriptHandlerInternal create(ScriptSource scriptSource, ScriptCompileScope parentScope) {
        return this.create(scriptSource, parentScope, new BasicDomainObjectContext());
    }

    public ScriptHandlerInternal create(ScriptSource scriptSource, ScriptCompileScope parentScope, DomainObjectContext context) {
        DependencyResolutionServices services = this.dependencyManagementServices.create(this.fileResolver, this.dependencyMetaDataProvider, this.projectFinder, context);
        RepositoryHandler repositoryHandler = services.getResolveRepositoryHandler();
        ConfigurationContainerInternal configurationContainer = services.getConfigurationContainer();
        DependencyHandler dependencyHandler = services.getDependencyHandler();
        List<Object> key = Arrays.asList(scriptSource.getClassName(), parentScope);
        ScriptHandlerInternal originalHandler = this.classLoaderCache.get(key);
        if (originalHandler == null) {
            DefaultScriptHandler handler = new DefaultScriptHandler(scriptSource, repositoryHandler, dependencyHandler, configurationContainer, parentScope);
            this.classLoaderCache.put(key, handler);
            return handler;
        }
        return new NoClassLoaderUpdateScriptHandler(originalHandler.getBaseCompilationClassLoader(), originalHandler.getClassLoader(), repositoryHandler, dependencyHandler, scriptSource, configurationContainer);
    }

    private static class BasicDomainObjectContext
    implements DomainObjectContext {
        private BasicDomainObjectContext() {
        }

        public String absoluteProjectPath(String name) {
            return name;
        }
    }
}

