/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import org.gradle.api.internal.file.pattern.AnyWildcardPatternStep;
import org.gradle.api.internal.file.pattern.FixedPatternStep;
import org.gradle.api.internal.file.pattern.GreedyPatternStep;
import org.gradle.api.internal.file.pattern.PatternStep;
import org.gradle.api.internal.file.pattern.RegExpPatternStep;
import org.gradle.api.internal.file.pattern.WildcardPrefixPatternStep;

public class PatternStepFactory {
    public static PatternStep getStep(String source, boolean caseSensitive) {
        if (source.length() == 0) {
            return new FixedPatternStep(source, caseSensitive);
        }
        char ch = source.charAt(0);
        if (ch == '*') {
            int pos;
            if (source.length() == 1) {
                return new AnyWildcardPatternStep();
            }
            if (source.length() == 2 && source.charAt(1) == '*') {
                return new GreedyPatternStep();
            }
            for (pos = 1; pos < source.length() && source.charAt(pos) == '*'; ++pos) {
            }
            for (int i = pos; i < source.length(); ++i) {
                ch = source.charAt(i);
                if (ch != '?' && ch != '*') continue;
                return new RegExpPatternStep(source, caseSensitive);
            }
            return new WildcardPrefixPatternStep(source.substring(pos), caseSensitive);
        }
        for (int i = 0; i < source.length(); ++i) {
            ch = source.charAt(i);
            if (ch != '?' && ch != '*') continue;
            return new RegExpPatternStep(source, caseSensitive);
        }
        return new FixedPatternStep(source, caseSensitive);
    }
}

