/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionExecuter;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecWrapper;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.internal.file.copy.DestinationRootCopySpec;
import org.gradle.api.internal.file.copy.FileCopyAction;
import org.gradle.api.internal.file.copy.SyncCopyActionDecorator;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.nativeplatform.filesystem.FileSystems;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCopier {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;

    public FileCopier(Instantiator instantiator, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
    }

    private DestinationRootCopySpec createCopySpec(Action<? super CopySpec> action) {
        DefaultCopySpec copySpec = (DefaultCopySpec)this.instantiator.newInstance(DefaultCopySpec.class, new Object[]{this.fileResolver, this.instantiator});
        DestinationRootCopySpec destinationRootCopySpec = (DestinationRootCopySpec)this.instantiator.newInstance(DestinationRootCopySpec.class, new Object[]{this.fileResolver, copySpec});
        CopySpec wrapped = (CopySpec)this.instantiator.newInstance(CopySpecWrapper.class, new Object[]{destinationRootCopySpec});
        action.execute((Object)wrapped);
        return destinationRootCopySpec;
    }

    public WorkResult copy(Action<? super CopySpec> action) {
        DestinationRootCopySpec copySpec = this.createCopySpec(action);
        File destinationDir = copySpec.getDestinationDir();
        return this.doCopy(copySpec, this.getCopyVisitor(destinationDir));
    }

    public WorkResult sync(Action<? super CopySpec> action) {
        DestinationRootCopySpec copySpec = this.createCopySpec(action);
        File destinationDir = copySpec.getDestinationDir();
        return this.doCopy(copySpec, new SyncCopyActionDecorator(destinationDir, this.getCopyVisitor(destinationDir)));
    }

    private FileCopyAction getCopyVisitor(File destination) {
        return new FileCopyAction(this.fileResolver.withBaseDir(destination));
    }

    private WorkResult doCopy(CopySpecInternal copySpec, CopyAction visitor) {
        CopyActionExecuter visitorDriver = new CopyActionExecuter(this.instantiator, FileSystems.getDefault());
        return visitorDriver.execute(copySpec, visitor);
    }
}

