/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import org.gradle.api.Action;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DefaultFileCopyDetails;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;

public class CopyFileVisitorImpl
implements FileVisitor {
    private final CopySpecInternal spec;
    private final CopyActionProcessingStreamAction action;
    private final Instantiator instantiator;
    private final FileSystem fileSystem;

    public CopyFileVisitorImpl(CopySpecInternal spec, CopyActionProcessingStreamAction action, Instantiator instantiator, FileSystem fileSystem) {
        this.spec = spec;
        this.action = action;
        this.instantiator = instantiator;
        this.fileSystem = fileSystem;
    }

    public void visitDir(FileVisitDetails dirDetails) {
        this.processDir(dirDetails);
    }

    public void visitFile(FileVisitDetails fileDetails) {
        this.processFile(fileDetails);
    }

    private void processDir(FileVisitDetails visitDetails) {
        DefaultFileCopyDetails details = this.createDefaultFileCopyDetails(visitDetails);
        this.action.processFile(details);
    }

    private void processFile(FileVisitDetails visitDetails) {
        DefaultFileCopyDetails details = this.createDefaultFileCopyDetails(visitDetails);
        for (Action<? super FileCopyDetails> action : this.spec.getAllCopyActions()) {
            action.execute((Object)details);
            if (!details.isExcluded()) continue;
            return;
        }
        this.action.processFile(details);
    }

    private DefaultFileCopyDetails createDefaultFileCopyDetails(FileVisitDetails visitDetails) {
        return (DefaultFileCopyDetails)this.instantiator.newInstance(DefaultFileCopyDetails.class, new Object[]{visitDetails, this.spec, this.fileSystem});
    }
}

