/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.pattern.PatternStep;
import org.gradle.api.internal.file.pattern.PatternStepFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.util.PatternSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleIncludePatternFileTree
implements MinimalFileTree {
    private final File baseDir;
    private final String includePattern;
    private final List<String> patternSegments;
    private final Spec<FileTreeElement> excludeSpec;

    public SingleIncludePatternFileTree(File baseDir, String includePattern) {
        this(baseDir, includePattern, Specs.satisfyNone());
    }

    public SingleIncludePatternFileTree(File baseDir, String includePattern, Spec<FileTreeElement> excludeSpec) {
        this.baseDir = baseDir;
        if (includePattern.endsWith("/") || includePattern.endsWith("\\")) {
            includePattern = includePattern + "**";
        }
        this.includePattern = includePattern;
        this.patternSegments = Arrays.asList(includePattern.split("[/\\\\]"));
        this.excludeSpec = excludeSpec;
    }

    @Override
    public void visit(FileVisitor visitor) {
        this.doVisit(visitor, this.baseDir, new LinkedList<String>(), 0, new AtomicBoolean());
    }

    private void doVisit(FileVisitor visitor, File file, LinkedList<String> relativePath, int segmentIndex, AtomicBoolean stopFlag) {
        if (stopFlag.get()) {
            return;
        }
        String segment = this.patternSegments.get(segmentIndex);
        if (segment.contains("**")) {
            PatternSet patternSet = new PatternSet();
            patternSet.include(this.includePattern);
            patternSet.exclude((Spec)this.excludeSpec);
            DirectoryFileTree fileTree = new DirectoryFileTree(this.baseDir, patternSet);
            fileTree.visitFrom(visitor, file, new RelativePath(file.isFile(), relativePath.toArray(new String[relativePath.size()])));
        } else if (segment.contains("*") || segment.contains("?")) {
            PatternStep step = PatternStepFactory.getStep(segment, false);
            File[] children = file.listFiles();
            if (children == null) {
                if (!file.canRead()) {
                    throw new GradleException(String.format("Could not list contents of directory '%s' as it is not readable.", file));
                }
                throw new GradleException(String.format("Could not list contents of '%s'.", file));
            }
            for (File child : children) {
                if (!stopFlag.get()) {
                    if (!step.matches(child.getName())) continue;
                    relativePath.addLast(child.getName());
                    this.doVisitDirOrFile(visitor, child, relativePath, segmentIndex + 1, stopFlag);
                    relativePath.removeLast();
                    continue;
                }
                break;
            }
        } else {
            relativePath.addLast(segment);
            this.doVisitDirOrFile(visitor, new File(file, segment), relativePath, segmentIndex + 1, stopFlag);
            relativePath.removeLast();
        }
    }

    private void doVisitDirOrFile(FileVisitor visitor, File file, LinkedList<String> relativePath, int segmentIndex, AtomicBoolean stopFlag) {
        if (file.isFile()) {
            RelativePath path;
            DefaultFileVisitDetails details;
            if (segmentIndex == this.patternSegments.size() && !this.excludeSpec.isSatisfiedBy((Object)(details = new DefaultFileVisitDetails(file, path = new RelativePath(true, relativePath.toArray(new String[relativePath.size()])), stopFlag)))) {
                visitor.visitFile(details);
            }
        } else if (file.isDirectory()) {
            RelativePath path = new RelativePath(false, relativePath.toArray(new String[relativePath.size()]));
            DefaultFileVisitDetails details = new DefaultFileVisitDetails(file, path, stopFlag);
            if (!this.excludeSpec.isSatisfiedBy((Object)details)) {
                visitor.visitDir(details);
            }
            if (segmentIndex < this.patternSegments.size()) {
                this.doVisit(visitor, file, relativePath, segmentIndex, stopFlag);
            }
        }
    }

    @Override
    public String getDisplayName() {
        return "directory '" + this.baseDir + "' include '" + this.includePattern + "'";
    }
}

