/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.internal;

import org.gradle.api.Action;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ScriptClassLoaderProvider;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.PluginAware;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.internal.DefaultPluginHandler;
import org.gradle.plugin.internal.NonPluggableTargetPluginHandler;
import org.gradle.plugin.internal.PluginHandlerFactory;
import org.gradle.plugin.internal.PluginHandlerInternal;
import org.gradle.plugin.internal.PluginResolutionApplicator;
import org.gradle.plugin.resolve.internal.AndroidPluginMapper;
import org.gradle.plugin.resolve.internal.ModuleMappingPluginResolver;
import org.gradle.plugin.resolve.internal.PluginRegistryPluginResolver;
import org.gradle.plugin.resolve.internal.TomcatPluginMapper;

public class DefaultPluginHandlerFactory
implements PluginHandlerFactory {
    private final PluginRegistry pluginRegistry;
    private final Instantiator instantiator;
    private final DependencyManagementServices dependencyManagementServices;
    private final FileResolver fileResolver;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final ClassLoader parentClassLoader;
    private final ProjectFinder projectFinder = new ProjectFinder(){

        public ProjectInternal getProject(String path) {
            throw new UnknownProjectException("Cannot use project dependencies in a plugin resolution definition.");
        }
    };

    public DefaultPluginHandlerFactory(PluginRegistry pluginRegistry, Instantiator instantiator, DependencyManagementServices dependencyManagementServices, FileResolver fileResolver, DependencyMetaDataProvider dependencyMetaDataProvider, ClassLoader parentClassLoader) {
        this.pluginRegistry = pluginRegistry;
        this.instantiator = instantiator;
        this.dependencyManagementServices = dependencyManagementServices;
        this.fileResolver = fileResolver;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.parentClassLoader = parentClassLoader;
    }

    public PluginHandlerInternal createPluginHandler(Object target, ScriptClassLoaderProvider classLoaderProvider) {
        if (target instanceof PluginAware) {
            DefaultPluginHandler pluginHandler = new DefaultPluginHandler(this.instantiator, new PluginResolutionApplicator((PluginAware)target, this.parentClassLoader));
            this.addDefaultResolvers(pluginHandler, classLoaderProvider);
            return pluginHandler;
        }
        return new NonPluggableTargetPluginHandler(target);
    }

    private void addDefaultResolvers(PluginHandlerInternal pluginHandler, ScriptClassLoaderProvider classLoaderProvider) {
        pluginHandler.getResolvers().add(new PluginRegistryPluginResolver(this.pluginRegistry));
        pluginHandler.getResolvers().add(new ModuleMappingPluginResolver("android plugin resolver", classLoaderProvider, this.createDependencyResolutionServices(), this.instantiator, new AndroidPluginMapper(), new JCenterRepositoryConfigurer()));
        pluginHandler.getResolvers().add(new ModuleMappingPluginResolver("tomcat plugin resolver", classLoaderProvider, this.createDependencyResolutionServices(), this.instantiator, new TomcatPluginMapper(), new JCenterRepositoryConfigurer()));
    }

    private DependencyResolutionServices createDependencyResolutionServices() {
        return this.dependencyManagementServices.create(this.fileResolver, this.dependencyMetaDataProvider, this.projectFinder, new BasicDomainObjectContext());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JCenterRepositoryConfigurer
    implements Action<RepositoryHandler> {
        private JCenterRepositoryConfigurer() {
        }

        public void execute(RepositoryHandler repositories) {
            repositories.jcenter();
        }
    }

    private static class BasicDomainObjectContext
    implements DomainObjectContext {
        private BasicDomainObjectContext() {
        }

        public String absoluteProjectPath(String name) {
            return name;
        }
    }
}

