/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal.logback;

import ch.qos.logback.classic.Level;
import org.gradle.api.Nullable;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logging;
import org.slf4j.Marker;

public class LogLevelConverter {
    @Nullable
    public static LogLevel toGradleLogLevel(Level level, @Nullable Marker marker) {
        switch (level.toInt()) {
            case 5000: {
                return null;
            }
            case 10000: {
                return LogLevel.DEBUG;
            }
            case 20000: {
                if (marker == Logging.LIFECYCLE) {
                    return LogLevel.LIFECYCLE;
                }
                if (marker == Logging.QUIET) {
                    return LogLevel.QUIET;
                }
                return LogLevel.INFO;
            }
            case 30000: {
                return LogLevel.WARN;
            }
            case 40000: {
                return LogLevel.ERROR;
            }
        }
        throw new IllegalArgumentException("Don't know how to map Logback log level '" + level + "' to a Gradle log level");
    }

    public static Level toLogbackLevel(LogLevel level) {
        switch (level) {
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: 
            case LIFECYCLE: 
            case QUIET: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        throw new IllegalArgumentException("Don't know how to map Gradle log level '" + (Object)((Object)level) + "' to a Logback log level");
    }
}

