/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.GradleException;
import org.gradle.internal.typeconversion.CompositeNotationParser;
import org.gradle.internal.typeconversion.EnumFromStringNotationParser;
import org.gradle.internal.typeconversion.JustReturningParser;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypeInfo;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionNotationParserFactory<T> {
    private TypeInfo<T> resultingType;

    public OptionNotationParserFactory<T> resultingType(TypeInfo<T> resultingType) {
        this.resultingType = resultingType;
        return this;
    }

    public OptionNotationParserFactory(Class<T> optionType) {
        this.resultingType(new TypeInfo(optionType));
    }

    public NotationParser<T> toComposite() {
        return this.create();
    }

    private NotationParser<T> create() {
        assert (this.resultingType != null) : "resultingType cannot be null";
        ArrayList parsers = new ArrayList();
        Class<T> targetType = this.resultingType.getTargetType();
        if (targetType == Void.TYPE) {
            parsers.add(new UnsupportedNotationParser());
        }
        if (targetType.isAssignableFrom(String.class)) {
            parsers.add(new NoDescriptionJustReturningParser(targetType));
        }
        if (targetType.isEnum()) {
            parsers.add(new NoDescriptionJustReturningParser(targetType));
            parsers.add(new EnumFromStringNotationParser<T>(targetType));
        }
        if (parsers.isEmpty()) {
            throw new GradleException(String.format("resultingType '%s' not supported", targetType.getName()));
        }
        return new CompositeNotationParser(parsers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NoDescriptionJustReturningParser
    extends JustReturningParser<T> {
        public NoDescriptionJustReturningParser(Class<T> targetType) {
            super(targetType);
        }

        @Override
        public void describe(Collection<String> candidateFormats) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnsupportedNotationParser
    implements NotationParser<T> {
        private UnsupportedNotationParser() {
        }

        @Override
        public T parseNotation(Object notation) throws UnsupportedNotationException, TypeConversionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void describe(Collection<String> candidateFormats) {
        }
    }
}

