/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.internal.typeconversion.CompositeNotationParser;
import org.gradle.internal.typeconversion.ErrorHandlingNotationParser;
import org.gradle.internal.typeconversion.FlatteningNotationParser;
import org.gradle.internal.typeconversion.JustReturningParser;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.TypeInfo;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotationParserBuilder<T> {
    private TypeInfo<T> resultingType;
    private String invalidNotationMessage;
    private Collection<NotationParser<? extends T>> notationParsers = new LinkedList<NotationParser<? extends T>>();
    private boolean withJustReturningParser = true;

    public NotationParserBuilder<T> resultingType(Class<T> resultingType) {
        return this.resultingType(new TypeInfo(resultingType));
    }

    public NotationParserBuilder<T> resultingType(TypeInfo<T> resultingType) {
        this.resultingType = resultingType;
        return this;
    }

    public NotationParserBuilder<T> withDefaultJustReturnParser(boolean withJustReturningParser) {
        this.withJustReturningParser = withJustReturningParser;
        return this;
    }

    public NotationParserBuilder<T> parser(NotationParser<? extends T> parser) {
        this.notationParsers.add(parser);
        return this;
    }

    public NotationParserBuilder<T> invalidNotationMessage(String invalidNotationMessage) {
        this.invalidNotationMessage = invalidNotationMessage;
        return this;
    }

    public NotationParserBuilder<T> parsers(Iterable<? extends NotationParser<? extends T>> notationParsers) {
        GUtil.addToCollection(this.notationParsers, notationParsers);
        return this;
    }

    public NotationParser<Set<T>> toFlatteningComposite() {
        return this.wrapInErrorHandling(new FlatteningNotationParser<T>(this.create()));
    }

    public NotationParser<T> toComposite() {
        return this.wrapInErrorHandling(this.create());
    }

    private <S> NotationParser<S> wrapInErrorHandling(NotationParser<S> parser) {
        return new ErrorHandlingNotationParser<S>(this.resultingType.getTargetType().getSimpleName(), this.invalidNotationMessage, parser);
    }

    private CompositeNotationParser<T> create() {
        assert (this.resultingType != null) : "resultingType cannot be null";
        LinkedList composites = new LinkedList();
        if (this.withJustReturningParser) {
            composites.add(new JustReturningParser<T>(this.resultingType.getTargetType()));
        }
        composites.addAll(this.notationParsers);
        return new CompositeNotationParser(composites);
    }
}

