/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypedNotationParser;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumFromStringNotationParser<T>
extends TypedNotationParser<CharSequence, T> {
    private final Class<T> type;

    public EnumFromStringNotationParser(Class<T> enumType) {
        super(CharSequence.class);
        assert (enumType.isEnum()) : "resultingType must be enum";
        this.type = enumType;
    }

    @Override
    protected T parseType(CharSequence notation) {
        if (this.type.isEnum()) {
            final String enumString = notation.toString();
            List<T> enumConstants = Arrays.asList(this.type.getEnumConstants());
            Object match = CollectionUtils.findFirst(enumConstants, (Spec)new Spec<T>(){

                public boolean isSatisfiedBy(T enumValue) {
                    return ((Enum)enumValue).name().equalsIgnoreCase(enumString);
                }
            });
            if (match == null) {
                throw new TypeConversionException(String.format("Cannot coerce string value '%s' to an enum value of type '%s' (valid case insensitive values: %s)", enumString, this.type.getName(), CollectionUtils.toStringList(Arrays.asList(this.type.getEnumConstants()))));
            }
            return (T)match;
        }
        throw new UnsupportedNotationException((Object)"type must be an Enum");
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        if (this.type.isEnum()) {
            Enum[] enumConstants;
            for (Enum enumConstant : enumConstants = (Enum[])this.type.getEnumConstants()) {
                candidateFormats.add(enumConstant.name());
            }
        }
    }
}

