/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.execution.taskgraph.DefaultTaskPlanExecutor;
import org.gradle.execution.taskgraph.ParallelTaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.ExecutorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPlanExecutorFactory
implements Factory<TaskPlanExecutor> {
    private final TaskArtifactStateCacheAccess taskArtifactStateCacheAccess;
    private final int parallelThreads;
    private final ExecutorFactory executorFactory;

    public TaskPlanExecutorFactory(TaskArtifactStateCacheAccess taskArtifactStateCacheAccess, int parallelThreads, ExecutorFactory executorFactory) {
        this.taskArtifactStateCacheAccess = taskArtifactStateCacheAccess;
        this.parallelThreads = parallelThreads;
        this.executorFactory = executorFactory;
    }

    public TaskPlanExecutor create() {
        if (this.executeProjectsInParallel()) {
            return new ParallelTaskPlanExecutor(this.taskArtifactStateCacheAccess, this.numberOfParallelThreads(), this.executorFactory);
        }
        return new DefaultTaskPlanExecutor(this.taskArtifactStateCacheAccess);
    }

    private boolean executeProjectsInParallel() {
        return this.parallelThreads != 0;
    }

    private int numberOfParallelThreads() {
        if (this.parallelThreads == -1) {
            return Runtime.getRuntime().availableProcessors();
        }
        return this.parallelThreads;
    }
}

