/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.execution.taskgraph.AbstractTaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParallelTaskPlanExecutor
extends AbstractTaskPlanExecutor {
    private static final Logger LOGGER = Logging.getLogger(ParallelTaskPlanExecutor.class);
    private final int executorCount;
    private final TaskArtifactStateCacheAccess cacheAccess;
    private final ExecutorFactory executorFactory;

    public ParallelTaskPlanExecutor(TaskArtifactStateCacheAccess cacheAccess, int numberOfParallelExecutors, ExecutorFactory executorFactory) {
        this.cacheAccess = cacheAccess;
        this.executorFactory = executorFactory;
        if (numberOfParallelExecutors < 1) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        this.executorCount = numberOfParallelExecutors;
    }

    @Override
    public void process(final TaskExecutionPlan taskExecutionPlan, final TaskExecutionListener taskListener) {
        this.cacheAccess.longRunningOperation("Executing all tasks", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                StoppableExecutor executor = ParallelTaskPlanExecutor.this.executorFactory.create("Task worker");
                try {
                    ParallelTaskPlanExecutor.this.startAdditionalWorkers(taskExecutionPlan, taskListener, (Executor)executor);
                    ParallelTaskPlanExecutor.this.taskWorker(taskExecutionPlan, taskListener).run();
                    taskExecutionPlan.awaitCompletion();
                }
                finally {
                    executor.stop();
                }
            }
        });
    }

    private void startAdditionalWorkers(TaskExecutionPlan taskExecutionPlan, TaskExecutionListener taskListener, Executor executor) {
        List<Project> projects = this.getAllProjects(taskExecutionPlan);
        int numExecutors = Math.min(this.executorCount, projects.size());
        LOGGER.info("Using {} parallel executor threads", numExecutors);
        for (int i = 1; i < numExecutors; ++i) {
            Runnable worker = this.taskWorker(taskExecutionPlan, taskListener);
            executor.execute(worker);
        }
    }

    private List<Project> getAllProjects(TaskExecutionPlan taskExecutionPlan) {
        LinkedHashSet<Project> uniqueProjects = new LinkedHashSet<Project>();
        for (Task task : taskExecutionPlan.getTasks()) {
            uniqueProjects.add(task.getProject());
        }
        return new ArrayList<Project>(uniqueProjects);
    }
}

