/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.CacheUsage;
import org.gradle.api.Action;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheLayout;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.DirectoryCacheBuilder;
import org.gradle.cache.ObjectCacheBuilder;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.CacheLayoutBuilder;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.messaging.serialize.DefaultSerializer;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheRepository
implements CacheRepository {
    private final File globalCacheDir;
    private final CacheUsage cacheUsage;
    private final File projectCacheDir;
    private final CacheFactory factory;

    public DefaultCacheRepository(File userHomeDir, File projectCacheDir, CacheUsage cacheUsage, CacheFactory factory) {
        this.projectCacheDir = projectCacheDir;
        this.factory = factory;
        this.globalCacheDir = new File(userHomeDir, "caches");
        this.cacheUsage = cacheUsage;
    }

    @Override
    public DirectoryCacheBuilder store(String key) {
        return new PersistentStoreBuilder(key);
    }

    @Override
    public DirectoryCacheBuilder cache(String key) {
        return new PersistentCacheBuilder(key);
    }

    @Override
    public <E> ObjectCacheBuilder<E, PersistentStateCache<E>> stateCache(Class<E> elementType, String key) {
        return new StateCacheBuilder(key);
    }

    @Override
    public <K, V> ObjectCacheBuilder<V, PersistentIndexedCache<K, V>> indexedCache(Class<K> keyType, Class<V> elementType, String key) {
        return new IndexedCacheBuilder(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexedCacheBuilder<K, V>
    extends AbstractObjectCacheBuilder<V, PersistentIndexedCache<K, V>> {
        private IndexedCacheBuilder(String key) {
            super(key);
        }

        @Override
        protected PersistentIndexedCache<K, V> doOpen(File cacheDir, Map<String, ?> properties, CacheValidator validator) {
            return DefaultCacheRepository.this.factory.openIndexedCache(cacheDir, DefaultCacheRepository.this.cacheUsage, validator, properties, LockOptionsBuilder.mode(FileLockManager.LockMode.Exclusive), this.serializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StateCacheBuilder<E>
    extends AbstractObjectCacheBuilder<E, PersistentStateCache<E>> {
        protected StateCacheBuilder(String key) {
            super(key);
        }

        @Override
        protected PersistentStateCache<E> doOpen(File cacheDir, Map<String, ?> properties, CacheValidator validator) {
            return DefaultCacheRepository.this.factory.openStateCache(cacheDir, DefaultCacheRepository.this.cacheUsage, validator, properties, LockOptionsBuilder.mode(FileLockManager.LockMode.Exclusive), this.serializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractObjectCacheBuilder<E, T>
    extends AbstractCacheBuilder<T>
    implements ObjectCacheBuilder<E, T> {
        protected Serializer<E> serializer;

        protected AbstractObjectCacheBuilder(String key) {
            super(key);
            this.serializer = new DefaultSerializer();
        }

        @Override
        public ObjectCacheBuilder<E, T> withProperties(Map<String, ?> properties) {
            super.withProperties(properties);
            return this;
        }

        @Override
        public ObjectCacheBuilder<E, T> withLayout(CacheLayout layout) {
            super.withLayout(layout);
            return this;
        }

        @Override
        public ObjectCacheBuilder<E, T> withSerializer(Serializer<E> serializer) {
            this.serializer = serializer;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PersistentStoreBuilder
    extends PersistentCacheBuilder {
        private PersistentStoreBuilder(String key) {
            super(key);
        }

        @Override
        protected PersistentCache doOpen(File cacheDir, Map<String, ?> properties, CacheValidator validator) {
            if (!properties.isEmpty()) {
                throw new UnsupportedOperationException("Properties are not supported for stores.");
            }
            return DefaultCacheRepository.this.factory.openStore(cacheDir, this.displayName, this.lockOptions, (Action<? super PersistentCache>)this.initializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PersistentCacheBuilder
    extends AbstractCacheBuilder<PersistentCache>
    implements DirectoryCacheBuilder {
        Action<? super PersistentCache> initializer;
        LockOptions lockOptions;
        String displayName;

        protected PersistentCacheBuilder(String key) {
            super(key);
            this.lockOptions = LockOptionsBuilder.mode(FileLockManager.LockMode.Shared);
        }

        @Override
        public DirectoryCacheBuilder withLayout(CacheLayout layout) {
            super.withLayout(layout);
            return this;
        }

        @Override
        public DirectoryCacheBuilder withProperties(Map<String, ?> properties) {
            super.withProperties(properties);
            return this;
        }

        @Override
        public DirectoryCacheBuilder withValidator(CacheValidator validator) {
            super.withValidator(validator);
            return this;
        }

        @Override
        public DirectoryCacheBuilder withInitializer(Action<? super PersistentCache> initializer) {
            this.initializer = initializer;
            return this;
        }

        @Override
        public DirectoryCacheBuilder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public DirectoryCacheBuilder withLockOptions(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        @Override
        protected PersistentCache doOpen(File cacheDir, Map<String, ?> properties, CacheValidator validator) {
            return DefaultCacheRepository.this.factory.open(cacheDir, this.displayName, DefaultCacheRepository.this.cacheUsage, validator, properties, this.lockOptions, this.initializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractCacheBuilder<T>
    implements CacheBuilder<T> {
        private final String key;
        private Map<String, ?> properties = Collections.emptyMap();
        private CacheLayout layout;
        private CacheValidator validator;

        protected AbstractCacheBuilder(String key) {
            this.key = key;
            this.layout = new CacheLayoutBuilder().build();
        }

        @Override
        public CacheBuilder<T> withProperties(Map<String, ?> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public CacheBuilder<T> withLayout(CacheLayout layout) {
            this.layout = layout;
            return this;
        }

        @Override
        public CacheBuilder<T> withValidator(CacheValidator validator) {
            this.validator = validator;
            return this;
        }

        @Override
        public T open() {
            File cacheBaseDir = this.layout.getCacheDir(DefaultCacheRepository.this.globalCacheDir, DefaultCacheRepository.this.projectCacheDir, this.key);
            Map<String, ?> props = this.layout.applyLayoutProperties(this.properties);
            return this.doOpen(cacheBaseDir, props, this.validator);
        }

        protected abstract T doOpen(File var1, Map<String, ?> var2, CacheValidator var3);
    }
}

