/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheAccess;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.DefaultMultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.FileAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.UnitOfWorkParticipant;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.cache.internal.cacheops.CacheAccessOperationsStack;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultCacheAccess
implements CacheAccess {
    private static final Logger LOG = Logging.getLogger(DefaultCacheAccess.class);
    private final String cacheDisplayName;
    private final File lockFile;
    private final FileLockManager lockManager;
    private final FileAccess fileAccess = new UnitOfWorkFileAccess();
    private final Set<MultiProcessSafePersistentIndexedCache> caches = new HashSet<MultiProcessSafePersistentIndexedCache>();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private Thread owner;
    private LockOptions lockOptions;
    private FileLock fileLock;
    private FileLock.State stateAtOpen;
    private boolean contended;
    private final CacheAccessOperationsStack operations;
    private int cacheClosedCount;

    public DefaultCacheAccess(String cacheDisplayName, File lockFile, FileLockManager lockManager) {
        this.cacheDisplayName = cacheDisplayName;
        this.lockFile = lockFile;
        this.lockManager = lockManager;
        this.operations = new CacheAccessOperationsStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(LockOptions lockOptions) {
        this.lock.lock();
        try {
            if (this.owner != null) {
                throw new IllegalStateException(String.format("Cannot open the %s, as it is already in use.", this.cacheDisplayName));
            }
            this.lockOptions = lockOptions;
            if (lockOptions.getMode() == FileLockManager.LockMode.None) {
                return;
            }
            if (this.fileLock != null) {
                throw new IllegalStateException("File lock " + this.lockFile + " is already open.");
            }
            this.fileLock = this.lockManager.lock(this.lockFile, lockOptions, this.cacheDisplayName);
            this.stateAtOpen = this.fileLock.getState();
            this.takeOwnership(String.format("Access %s", this.cacheDisplayName));
            this.lockManager.allowContention(this.fileLock, this.whenContended());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFileLock() {
        try {
            ++this.cacheClosedCount;
            try {
                new CompositeStoppable().add(this.caches).stop();
                FileLock.State state = this.fileLock.getState();
                for (MultiProcessSafePersistentIndexedCache cache : this.caches) {
                    cache.onEndWork(state);
                }
            }
            finally {
                this.fileLock.close();
            }
        }
        finally {
            this.fileLock = null;
            this.stateAtOpen = null;
            this.contended = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            if (this.fileLock != null) {
                this.closeFileLock();
            }
            if (this.cacheClosedCount != 1) {
                LOG.debug("Cache {} was closed {} times.", this.cacheDisplayName, this.cacheClosedCount);
            }
        }
        finally {
            this.lockOptions = null;
            this.owner = null;
            this.lock.unlock();
        }
    }

    public FileLock getFileLock() {
        return this.fileLock;
    }

    @Override
    public void useCache(String operationDisplayName, Runnable action) {
        this.useCache(operationDisplayName, Factories.toFactory((Runnable)action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T useCache(String operationDisplayName, Factory<? extends T> factory) {
        if (this.lockOptions != null && this.lockOptions.getMode() == FileLockManager.LockMode.Shared) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        this.takeOwnership(operationDisplayName);
        boolean wasStarted = false;
        try {
            wasStarted = this.onStartWork();
            Object object = factory.create();
            return (T)object;
        }
        finally {
            this.lock.lock();
            try {
                try {
                    if (wasStarted) {
                        this.onEndWork();
                    }
                }
                finally {
                    this.releaseOwnership();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeOwnership(String operationDisplayName) {
        this.lock.lock();
        try {
            while (this.owner != null && this.owner != Thread.currentThread()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            this.owner = Thread.currentThread();
            this.operations.pushCacheAction(operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseOwnership() {
        this.lock.lock();
        try {
            this.operations.popCacheAction();
            if (!this.operations.isInCacheAction()) {
                this.owner = null;
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T longRunningOperation(String operationDisplayName, Factory<? extends T> action) {
        boolean wasEnded = this.startLongRunningOperation(operationDisplayName);
        try {
            Object object = action.create();
            return (T)object;
        }
        finally {
            this.finishLongRunningOperation(wasEnded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startLongRunningOperation(String operationDisplayName) {
        boolean wasEnded;
        this.lock.lock();
        try {
            if (this.operations.isInCacheAction()) {
                this.checkThreadIsOwner();
                wasEnded = this.onEndWork();
                this.owner = null;
                this.condition.signalAll();
            } else {
                wasEnded = false;
            }
            this.operations.pushLongRunningOperation(operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
        return wasEnded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishLongRunningOperation(boolean wasEnded) {
        this.lock.lock();
        try {
            this.operations.popLongRunningOperation();
            if (this.operations.isInCacheAction()) {
                this.restoreOwner();
                if (wasEnded) {
                    this.onStartWork();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkThreadIsOwner() {
        this.lock.lock();
        try {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException(String.format("Cannot start long running operation, as the %s has not been locked.", this.cacheDisplayName));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreOwner() {
        this.lock.lock();
        try {
            while (this.owner != null) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            this.owner = Thread.currentThread();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void longRunningOperation(String operationDisplayName, Runnable action) {
        this.longRunningOperation(operationDisplayName, Factories.toFactory((Runnable)action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> MultiProcessSafePersistentIndexedCache<K, V> newCache(final PersistentIndexedCacheParameters<K, V> parameters) {
        Factory indexedCacheFactory = new Factory<BTreePersistentIndexedCache<K, V>>(){

            public BTreePersistentIndexedCache<K, V> create() {
                return DefaultCacheAccess.this.doCreateCache(parameters.getCacheFile(), parameters.getKeySerializer(), parameters.getValueSerializer());
            }
        };
        MultiProcessSafePersistentIndexedCache<K, V> indexedCache = parameters.decorate(new DefaultMultiProcessSafePersistentIndexedCache(indexedCacheFactory, this.fileAccess));
        this.lock.lock();
        try {
            this.caches.add(indexedCache);
            if (this.fileLock != null) {
                indexedCache.onStartWork(this.operations.getDescription(), this.stateAtOpen);
            }
        }
        finally {
            this.lock.unlock();
        }
        return indexedCache;
    }

    <K, V> BTreePersistentIndexedCache<K, V> doCreateCache(File cacheFile, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new BTreePersistentIndexedCache<K, V>(cacheFile, keySerializer, valueSerializer);
    }

    private boolean onStartWork() {
        if (this.fileLock != null) {
            return false;
        }
        this.fileLock = this.lockManager.lock(this.lockFile, this.lockOptions.withMode(FileLockManager.LockMode.Exclusive), this.cacheDisplayName, this.operations.getDescription());
        this.stateAtOpen = this.fileLock.getState();
        for (UnitOfWorkParticipant unitOfWorkParticipant : this.caches) {
            unitOfWorkParticipant.onStartWork(this.operations.getDescription(), this.stateAtOpen);
        }
        this.lockManager.allowContention(this.fileLock, this.whenContended());
        return true;
    }

    private boolean onEndWork() {
        if (this.fileLock == null) {
            return false;
        }
        if (this.contended || this.fileLock.getMode() == FileLockManager.LockMode.Shared) {
            this.closeFileLock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock getLock() {
        this.lock.lock();
        try {
            if (Thread.currentThread() != this.owner && this.owner != null || this.fileLock == null) {
                throw new IllegalStateException(String.format("The %s has not been locked for this thread. File lock: %s, owner: %s", this.cacheDisplayName, this.fileLock != null, this.owner));
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.fileLock;
    }

    Runnable whenContended() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DefaultCacheAccess.this.lock.lock();
                try {
                    LOG.debug("Detected file lock contention of {} (fileLock={}, contended={}, owner={})", DefaultCacheAccess.this.cacheDisplayName, DefaultCacheAccess.this.fileLock != null, DefaultCacheAccess.this.contended, DefaultCacheAccess.this.owner);
                    if (DefaultCacheAccess.this.fileLock == null) {
                        return;
                    }
                    if (DefaultCacheAccess.this.owner != null) {
                        DefaultCacheAccess.this.contended = true;
                        return;
                    }
                    DefaultCacheAccess.this.takeOwnership("Other process requested access to " + DefaultCacheAccess.this.cacheDisplayName);
                    try {
                        DefaultCacheAccess.this.closeFileLock();
                    }
                    finally {
                        DefaultCacheAccess.this.releaseOwnership();
                    }
                }
                finally {
                    DefaultCacheAccess.this.lock.unlock();
                }
            }
        };
    }

    Thread getOwner() {
        return this.owner;
    }

    FileAccess getFileAccess() {
        return this.fileAccess;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnitOfWorkFileAccess
    extends AbstractFileAccess {
        private UnitOfWorkFileAccess() {
        }

        public String toString() {
            return DefaultCacheAccess.this.cacheDisplayName;
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException {
            return DefaultCacheAccess.this.getLock().readFile(action);
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().updateFile(action);
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().writeFile(action);
        }
    }
}

