/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheLayout;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheLayoutBuilder
implements CacheLayout {
    private final GradleVersion version = GradleVersion.current();
    private File baseDir;
    private Project project;
    private String[] pathEntries = new String[0];
    private CacheBuilder.VersionStrategy versionStrategy = CacheBuilder.VersionStrategy.CachePerVersion;

    public CacheLayoutBuilder withGlobalScope() {
        this.project = null;
        return this;
    }

    public CacheLayoutBuilder withScope(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public CacheLayoutBuilder withBuildScope(Project project) {
        this.project = project.getRootProject();
        return this;
    }

    public CacheLayoutBuilder withPath(String ... pathEntries) {
        this.pathEntries = pathEntries;
        return this;
    }

    public CacheLayoutBuilder withSharedCache() {
        this.versionStrategy = CacheBuilder.VersionStrategy.SharedCache;
        return this;
    }

    public CacheLayoutBuilder withSharedCacheThatInvalidatesOnVersionChange() {
        this.versionStrategy = CacheBuilder.VersionStrategy.SharedCacheInvalidateOnVersionChange;
        return this;
    }

    public CacheLayout build() {
        return this;
    }

    @Override
    public File getCacheDir(File globalCacheDir, File projectCacheDir, String cacheKey) {
        File cacheBaseDir = this.determineBaseDir(globalCacheDir, projectCacheDir);
        cacheBaseDir = this.applyVersionStrategy(cacheBaseDir);
        for (String pathEntry : this.pathEntries) {
            cacheBaseDir = new File(cacheBaseDir, pathEntry);
        }
        return new File(cacheBaseDir, cacheKey);
    }

    private File determineBaseDir(File globalCacheDir, File projectCacheDir) {
        if (this.baseDir != null) {
            return new File(this.baseDir, ".gradle");
        }
        if (this.project != null) {
            return this.getProjectCacheDir(projectCacheDir);
        }
        return globalCacheDir;
    }

    private File applyVersionStrategy(File cacheBaseDir) {
        switch (this.versionStrategy) {
            case CachePerVersion: {
                return new File(cacheBaseDir, this.version.getVersion());
            }
            case SharedCacheInvalidateOnVersionChange: {
                return new File(cacheBaseDir, "noVersion");
            }
        }
        return cacheBaseDir;
    }

    private File getProjectCacheDir(File projectCacheDir) {
        if (projectCacheDir != null) {
            return projectCacheDir;
        }
        return new File(this.project.getProjectDir(), ".gradle");
    }

    @Override
    public Map<String, ?> applyLayoutProperties(Map<String, ?> properties) {
        HashMap layoutProperties = new HashMap(properties);
        if (this.versionStrategy == CacheBuilder.VersionStrategy.SharedCacheInvalidateOnVersionChange) {
            layoutProperties.put("gradle.version", this.version.getVersion());
        }
        return layoutProperties;
    }
}

