/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.internal.tasks.options.FieldOptionElement;
import org.gradle.api.internal.tasks.options.InstanceOptionDescriptor;
import org.gradle.api.internal.tasks.options.MethodOptionElement;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionReader {
    private ListMultimap<Class, OptionElement> cachedStaticClassDescriptors = ArrayListMultimap.create();

    public List<OptionDescriptor> getOptions(Object target) {
        Class<?> targetClass = target.getClass();
        HashMap<String, InstanceOptionDescriptor> options = new HashMap<String, InstanceOptionDescriptor>();
        if (!this.cachedStaticClassDescriptors.containsKey(targetClass)) {
            this.loadClassDescriptorInCache(target);
        }
        for (OptionElement optionElement : this.cachedStaticClassDescriptors.get(targetClass)) {
            options.put(optionElement.getOptionName(), new InstanceOptionDescriptor(target, optionElement));
        }
        return CollectionUtils.sort(options.values());
    }

    private void loadClassDescriptorInCache(Object target) {
        Collection<OptionElement> optionElements = this.getOptionElements(target);
        HashSet<String> processedOptionElements = new HashSet<String>();
        for (OptionElement optionElement : optionElements) {
            if (processedOptionElements.contains(optionElement.getOptionName())) {
                throw new OptionValidationException(String.format("Option '%s' linked to multiple elements in class '%s'.", optionElement.getOptionName(), target.getClass().getName()));
            }
            processedOptionElements.add(optionElement.getOptionName());
            this.cachedStaticClassDescriptors.put(target.getClass(), (Object)optionElement);
        }
    }

    private Collection<OptionElement> getOptionElements(Object target) {
        ArrayList<OptionElement> allOptionElements = new ArrayList<OptionElement>();
        for (Class<?> type = target.getClass(); type != Object.class && type != null; type = type.getSuperclass()) {
            allOptionElements.addAll(this.getMethodAnnotations(type));
            allOptionElements.addAll(this.getFieldAnnotations(type));
        }
        return allOptionElements;
    }

    private List<OptionElement> getFieldAnnotations(Class<?> type) {
        ArrayList<OptionElement> fieldOptionElements = new ArrayList<OptionElement>();
        for (Field field : type.getDeclaredFields()) {
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            if (Modifier.isStatic(field.getModifiers())) {
                throw new OptionValidationException(String.format("Option on static field '%s' not supported in class '%s'.", field.getName(), field.getDeclaringClass().getName()));
            }
            fieldOptionElements.add(new FieldOptionElement(option, field));
        }
        return fieldOptionElements;
    }

    private List<OptionElement> getMethodAnnotations(Class<?> type) {
        ArrayList<OptionElement> methodOptionElements = new ArrayList<OptionElement>();
        for (Method method : type.getDeclaredMethods()) {
            Option option = method.getAnnotation(Option.class);
            if (option == null) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                throw new OptionValidationException(String.format("Option on static method '%s' not supported in class '%s'.", method.getName(), method.getDeclaringClass().getName()));
            }
            MethodOptionElement methodOptionDescriptor = new MethodOptionElement(option, method);
            methodOptionElements.add(methodOptionDescriptor);
        }
        return methodOptionElements;
    }
}

