/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.lang.reflect.Method;
import java.util.List;
import org.gradle.api.internal.tasks.options.AbstractOptionElement;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.internal.tasks.options.OptionValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodOptionElement
extends AbstractOptionElement {
    private final Method method;

    public MethodOptionElement(Option option, Method method) {
        super(option.option(), option, MethodOptionElement.calculateOptionType(method), method.getDeclaringClass());
        this.method = method;
        MethodOptionElement.assertMethodTypeSupported(this.getOptionName(), method);
        this.assertValidOptionName();
    }

    private void assertValidOptionName() {
        if (this.getOptionName() == null || this.getOptionName().length() == 0) {
            throw new OptionValidationException(String.format("No option name set on '%s' in class '%s'.", this.getElementName(), this.getDeclaredClass().getName()));
        }
    }

    private static Class<?> calculateOptionType(Method optionMethod) {
        if (optionMethod.getParameterTypes().length == 0) {
            return Void.TYPE;
        }
        return MethodOptionElement.calculateOptionType(optionMethod.getParameterTypes()[0]);
    }

    @Override
    public Class<?> getDeclaredClass() {
        return this.method.getDeclaringClass();
    }

    @Override
    public String getElementName() {
        return this.method.getName();
    }

    @Override
    public void apply(Object object, List<String> parameterValues) {
        if (parameterValues.size() == 0) {
            this.invokeMethod(object, this.method, true);
        } else {
            if (parameterValues.size() > 1) {
                throw new IllegalArgumentException(String.format("Lists not supported for option.", new Object[0]));
            }
            this.invokeMethod(object, this.method, this.getNotationParser().parseNotation(parameterValues.get(0)));
        }
    }

    private static void assertMethodTypeSupported(String optionName, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new OptionValidationException(String.format("Option '%s' cannot be linked to methods with multiple parameters in class '%s#%s'.", optionName, method.getDeclaringClass().getName(), method.getName()));
        }
    }
}

