/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.api.internal.tasks.options.OptionValues;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceOptionDescriptor
implements OptionDescriptor {
    private final Object object;
    private final OptionElement optionElement;

    public InstanceOptionDescriptor(Object object, OptionElement optionElement) {
        this.object = object;
        this.optionElement = optionElement;
    }

    public OptionElement getOptionElement() {
        return this.optionElement;
    }

    @Override
    public String getName() {
        return this.optionElement.getOptionName();
    }

    @Override
    public List<String> getAvailableValues() {
        List<String> values = this.optionElement.getAvailableValues();
        if (this.getArgumentType().isAssignableFrom(String.class)) {
            values.addAll(this.readDynamicAvailableValues());
        }
        return values;
    }

    @Override
    public Class<?> getArgumentType() {
        return this.optionElement.getOptionType();
    }

    private List<String> readDynamicAvailableValues() {
        JavaMethod<Object, Collection> optionValueMethod = InstanceOptionDescriptor.getOptionValueMethod(this.object, this.getName());
        if (optionValueMethod != null) {
            Collection values = (Collection)optionValueMethod.invoke(this.object, new Object[0]);
            return CollectionUtils.toStringList((Iterable)values);
        }
        return Collections.emptyList();
    }

    @Override
    public String getDescription() {
        return this.optionElement.getDescription();
    }

    @Override
    public void apply(Object objectParam, List<String> parameterValues) {
        if (objectParam != this.object) {
            throw new AssertionError((Object)String.format("Object %s not applyable. Expecting %s", objectParam, this.object));
        }
        this.optionElement.apply(objectParam, parameterValues);
    }

    @Override
    public int compareTo(OptionDescriptor o) {
        return this.getName().compareTo(o.getName());
    }

    private static JavaMethod<Object, Collection> getOptionValueMethod(Object object, String name) {
        JavaMethod optionValueMethod = null;
        for (Class<?> type = object.getClass(); type != Object.class && type != null; type = type.getSuperclass()) {
            for (Method method : type.getDeclaredMethods()) {
                OptionValues optionValues = method.getAnnotation(OptionValues.class);
                if (optionValues == null) continue;
                if (Collection.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0 && !Modifier.isStatic(method.getModifiers())) {
                    if (!CollectionUtils.toList((Object[])optionValues.value()).contains(name)) continue;
                    if (optionValueMethod == null) {
                        optionValueMethod = JavaReflectionUtil.method(Object.class, Collection.class, (Method)method);
                        continue;
                    }
                    throw new OptionValidationException(String.format("OptionValues for '%s' cannot be attached to multiple methods in class '%s'.", name, type.getName()));
                }
                throw new OptionValidationException(String.format("OptionValues annotation not supported on method '%s' in class '%s'. Supported method must be non static, return Collection and take no parameters.", method.getName(), type.getName()));
            }
        }
        return optionValueMethod;
    }
}

