/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.OptionNotationParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractOptionElement
implements OptionElement {
    private final String optionName;
    private final String description;
    private final Class<?> optionType;
    private final NotationParser notationParser;

    public AbstractOptionElement(String optionName, Option option, Class<?> optionType, Class<?> declaringClass) {
        this.description = this.readDescription(option, optionName, declaringClass);
        this.optionName = optionName;
        this.optionType = optionType;
        this.notationParser = this.createNotationParser(optionName, optionType, declaringClass);
    }

    private NotationParser createNotationParser(String optionName, Class<?> optionType, Class<?> declaringClass) {
        try {
            return new OptionNotationParserFactory(optionType).toComposite();
        }
        catch (Exception ex) {
            throw new OptionValidationException(String.format("Option '%s' cannot be casted to type '%s' in class '%s'.", optionName, optionType.getName(), declaringClass.getName()));
        }
    }

    protected static Class<?> calculateOptionType(Class<?> type) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Void.TYPE;
        }
        return type;
    }

    @Override
    public List<String> getAvailableValues() {
        ArrayList<String> describes = new ArrayList<String>();
        this.notationParser.describe(describes);
        return describes;
    }

    @Override
    public Class<?> getOptionType() {
        return this.optionType;
    }

    private String readDescription(Option option, String optionName, Class<?> declaringClass) {
        try {
            return option.description();
        }
        catch (IncompleteAnnotationException ex) {
            throw new OptionValidationException(String.format("No description set on option '%s' at for class '%s'.", optionName, declaringClass.getName()));
        }
    }

    protected Object invokeMethod(Object object, Method method, Object ... parameterValues) {
        JavaMethod javaMethod = JavaReflectionUtil.method(Object.class, Object.class, (Method)method);
        return javaMethod.invoke(object, parameterValues);
    }

    @Override
    public String getOptionName() {
        return this.optionName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected NotationParser getNotationParser() {
        return this.notationParser;
    }
}

