/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.initialization.AbstractScriptHandler;
import org.gradle.api.internal.initialization.ScriptCompileScope;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScriptHandler
extends AbstractScriptHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultScriptHandler.class);
    private final ScriptCompileScope parentScope;
    private List<ClassLoader> parents = new ArrayList<ClassLoader>();
    private ClassLoader classLoader;
    private MutableURLClassLoader scriptClassPathClassLoader;
    private MultiParentClassLoader multiParentClassLoader;

    public DefaultScriptHandler(ScriptSource scriptSource, RepositoryHandler repositoryHandler, DependencyHandler dependencyHandler, ConfigurationContainer configContainer, ScriptCompileScope parentScope) {
        super(repositoryHandler, dependencyHandler, scriptSource, configContainer);
        this.parentScope = parentScope;
    }

    public ClassLoader getBaseCompilationClassLoader() {
        return this.parentScope.getScriptCompileClassLoader();
    }

    public ClassLoader getScriptCompileClassLoader() {
        if (this.classLoader == null) {
            LOGGER.debug("Eager creation of script class loader for {}. This may result in performance issues.", (Object)this.getSourceFile());
            this.scriptClassPathClassLoader = new MutableURLClassLoader(this.getBaseCompilationClassLoader(), new URL[0]);
            this.multiParentClassLoader = new MultiParentClassLoader(new ClassLoader[]{this.scriptClassPathClassLoader});
            this.classLoader = new CachingClassLoader((ClassLoader)this.multiParentClassLoader);
        }
        return this.classLoader;
    }

    public void addParent(ClassLoader parent) {
        if (this.parents == null) {
            throw new IllegalStateException("Cannot add a parent ClassLoader after script ClassLoader has been finalized.");
        }
        this.parents.add(parent);
    }

    public void updateClassPath() {
        if (this.classLoader == null) {
            ClassLoader current = this.getBaseCompilationClassLoader();
            Set<File> classPath = this.getClasspathConfiguration().getFiles();
            if (!classPath.isEmpty()) {
                MutableURLClassLoader mutableClassLoader = new MutableURLClassLoader(current, new URL[0]);
                this.addClassPath(mutableClassLoader);
                current = mutableClassLoader;
            }
            if (!this.parents.isEmpty()) {
                this.parents.add(0, current);
                current = new CachingClassLoader((ClassLoader)new MultiParentClassLoader(this.parents));
            }
            this.classLoader = current;
        } else {
            this.addClassPath(this.scriptClassPathClassLoader);
            for (ClassLoader parent : this.parents) {
                this.multiParentClassLoader.addParent(parent);
            }
        }
        this.parents = null;
    }

    private void addClassPath(MutableURLClassLoader mutableClassLoader) {
        for (File file : this.getClasspathConfiguration().getFiles()) {
            try {
                mutableClassLoader.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

