/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.hash;

import java.io.File;
import java.io.Serializable;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.hash.Hasher;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.PersistentIndexedCacheParameters;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;

public class CachingHasher
implements Hasher {
    private final PersistentIndexedCache<File, FileInfo> cache;
    private final Hasher hasher;
    private long timestamp;

    public CachingHasher(Hasher hasher, TaskArtifactStateCacheAccess cacheAccess) {
        this.hasher = hasher;
        this.cache = cacheAccess.createCache("fileHashes", File.class, new FileInfoSerializer());
    }

    public CachingHasher(Hasher hasher, PersistentCache persistentCache) {
        this.hasher = hasher;
        File cacheFile = new File(persistentCache.getBaseDir(), "fileHashes.bin");
        this.cache = persistentCache.createCache(new PersistentIndexedCacheParameters<File, FileInfo>(cacheFile, File.class, new FileInfoSerializer()));
    }

    public byte[] hash(File file) {
        FileInfo info = this.cache.get(file);
        long length = file.length();
        this.timestamp = file.lastModified();
        if (info != null && length == info.length && this.timestamp == info.timestamp) {
            return info.hash;
        }
        byte[] hash = this.hasher.hash(file);
        this.cache.put(file, new FileInfo(hash, length, this.timestamp));
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileInfoSerializer
    implements Serializer<FileInfo> {
        private FileInfoSerializer() {
        }

        public FileInfo read(Decoder decoder) throws Exception {
            byte[] hash = decoder.readBinary();
            long timestamp = decoder.readLong();
            long length = decoder.readLong();
            return new FileInfo(hash, length, timestamp);
        }

        public void write(Encoder encoder, FileInfo value) throws Exception {
            encoder.writeBinary(value.hash);
            encoder.writeLong(value.timestamp);
            encoder.writeLong(value.length);
        }
    }

    public static class FileInfo
    implements Serializable {
        private final byte[] hash;
        private final long timestamp;
        private final long length;

        public FileInfo(byte[] hash, long length, long timestamp) {
            this.hash = hash;
            this.length = length;
            this.timestamp = timestamp;
        }
    }
}

