/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.coerce;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.gradle.api.Transformer;
import org.gradle.api.internal.coerce.MethodArgumentsTransformer;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.typeconversion.EnumFromStringNotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCoercingMethodArgumentsTransformer
implements MethodArgumentsTransformer {
    @Override
    public Object[] transform(Object target, String methodName, Object ... args) {
        return this.maybeTransformForEnum(target, methodName, args);
    }

    private Object[] maybeTransformForEnum(Object target, final String methodName, Object ... args) {
        if (args.length != 1 || !(args[0] instanceof CharSequence)) {
            return args;
        }
        final CharSequence charSequenceArg = (CharSequence)args[0];
        final ArrayList enumMethodHolder = new ArrayList(2);
        final ArrayList stringMethodHolder = new ArrayList(1);
        JavaReflectionUtil.searchMethods(target.getClass(), (Transformer)new Transformer<Boolean, Method>(){

            public Boolean transform(Method method) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (method.getName().equals(methodName) && parameterTypes.length == 1) {
                    Class<?> parameterType = parameterTypes[0];
                    if (parameterType.isAssignableFrom(charSequenceArg.getClass())) {
                        stringMethodHolder.add(method);
                        return true;
                    }
                    if (parameterType.isEnum()) {
                        enumMethodHolder.add(method);
                        if (enumMethodHolder.size() > 1) {
                            return true;
                        }
                    }
                }
                return false;
            }
        });
        if (!stringMethodHolder.isEmpty()) {
            return args;
        }
        if (enumMethodHolder.size() != 1) {
            return args;
        }
        Method match = (Method)enumMethodHolder.get(0);
        Class<?> enumType = match.getParameterTypes()[0];
        return new Object[]{this.toEnumValue(enumType, charSequenceArg)};
    }

    public <T extends Enum<T>> T toEnumValue(Class<T> enumType, CharSequence charSequence) {
        EnumFromStringNotationParser<T> notationParser = new EnumFromStringNotationParser<T>(enumType);
        return (T)((Enum)notationParser.parseNotation(charSequence));
    }
}

