/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.HashMap;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotSerializer;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotter;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OutputFilesSnapshotSerializer
implements Serializer<FileCollectionSnapshot> {
    OutputFilesSnapshotSerializer() {
    }

    public FileCollectionSnapshot read(Decoder decoder) throws Exception {
        HashMap<String, Long> rootFileIds = new HashMap<String, Long>();
        int rootFileIdsCount = decoder.readInt();
        for (int i = 0; i < rootFileIdsCount; ++i) {
            String key = decoder.readString();
            boolean notNull = decoder.readBoolean();
            Long value = notNull ? Long.valueOf(decoder.readLong()) : null;
            rootFileIds.put(key, value);
        }
        FileSnapshotSerializer serializer = new FileSnapshotSerializer();
        FileCollectionSnapshot snapshot = serializer.read(decoder);
        return new OutputFilesSnapshotter.OutputFilesSnapshot(rootFileIds, snapshot);
    }

    public void write(Encoder encoder, FileCollectionSnapshot currentValue) throws Exception {
        OutputFilesSnapshotter.OutputFilesSnapshot value = (OutputFilesSnapshotter.OutputFilesSnapshot)currentValue;
        int rootFileIds = value.rootFileIds.size();
        encoder.writeInt(rootFileIds);
        for (String key : value.rootFileIds.keySet()) {
            Long id = value.rootFileIds.get(key);
            encoder.writeString((CharSequence)key);
            if (id == null) {
                encoder.writeBoolean(false);
                continue;
            }
            encoder.writeBoolean(true);
            encoder.writeLong(id.longValue());
        }
        FileSnapshotSerializer serializer = new FileSnapshotSerializer();
        serializer.write(encoder, value.filesSnapshot);
    }
}

