/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.InMemoryPersistentCacheDecorator;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryTaskArtifactCache
implements InMemoryPersistentCacheDecorator {
    private static final Logger LOG = Logging.getLogger(InMemoryTaskArtifactCache.class);
    private static final Object NULL = new Object();
    private final Object lock = new Object();
    private final Map<File, Cache<Object, Object>> cache = new HashMap<File, Cache<Object, Object>>();
    private final Map<File, FileLock.State> states = new HashMap<File, FileLock.State>();
    private static final Map<String, Integer> CACHE_CAPS = new HashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> MultiProcessSafePersistentIndexedCache<K, V> withMemoryCaching(final File cacheFile, final MultiProcessSafePersistentIndexedCache<K, V> original) {
        Cache data;
        Object object = this.lock;
        synchronized (object) {
            if (this.cache.containsKey(cacheFile)) {
                data = this.cache.get(cacheFile);
                LOG.info("In-memory cache of {}: Size{{}}, {}", cacheFile.getName(), data.size(), data.stats());
            } else {
                Integer maxSize = CACHE_CAPS.get(cacheFile.getName());
                assert (maxSize != null) : "Unknown cache.";
                data = CacheBuilder.newBuilder().maximumSize((long)maxSize.intValue()).build();
                this.cache.put(cacheFile, (Cache<Object, Object>)data);
            }
        }
        return new MultiProcessSafePersistentIndexedCache<K, V>(){

            @Override
            public void close() {
                original.close();
            }

            @Override
            public V get(K key) {
                assert (key instanceof String || key instanceof Long || key instanceof File) : "Unsupported key type: " + key;
                Object value = data.getIfPresent(key);
                if (value == NULL) {
                    return null;
                }
                if (value != null) {
                    return value;
                }
                Object out = original.get(key);
                data.put(key, out == null ? NULL : out);
                return out;
            }

            @Override
            public void put(K key, V value) {
                original.put(key, value);
                data.put(key, value);
            }

            @Override
            public void remove(K key) {
                data.put(key, NULL);
                original.remove(key);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStartWork(String operationDisplayName, FileLock.State currentCacheState) {
                boolean outOfDate;
                Object object = InMemoryTaskArtifactCache.this.lock;
                synchronized (object) {
                    FileLock.State previousState = (FileLock.State)InMemoryTaskArtifactCache.this.states.get(cacheFile);
                    outOfDate = previousState == null || currentCacheState.hasBeenUpdatedSince(previousState);
                }
                if (outOfDate) {
                    LOG.info("Invalidating in-memory cache of {}", cacheFile);
                    data.invalidateAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEndWork(FileLock.State currentCacheState) {
                Object object = InMemoryTaskArtifactCache.this.lock;
                synchronized (object) {
                    InMemoryTaskArtifactCache.this.states.put(cacheFile, currentCacheState);
                }
            }
        };
    }

    static {
        CACHE_CAPS.put("fileSnapshots.bin", 10000);
        CACHE_CAPS.put("taskArtifacts.bin", 2000);
        CACHE_CAPS.put("outputFileStates.bin", 3000);
        CACHE_CAPS.put("fileHashes.bin", 140000);
    }
}

