/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import org.gradle.api.Transformer;
import org.gradle.api.internal.changedetection.state.InMemoryPersistentCacheDecorator;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.CacheLayoutBuilder;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.listener.LazyCreationProxy;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskArtifactStateCacheAccess
implements TaskArtifactStateCacheAccess {
    private final Gradle gradle;
    private final CacheRepository cacheRepository;
    private InMemoryPersistentCacheDecorator inMemoryDecorator;
    private PersistentCache cache;
    private final Object lock = new Object();

    public DefaultTaskArtifactStateCacheAccess(Gradle gradle, CacheRepository cacheRepository, Factory<InMemoryPersistentCacheDecorator> decoratorFactory) {
        this.gradle = gradle;
        this.cacheRepository = cacheRepository;
        this.inMemoryDecorator = (InMemoryPersistentCacheDecorator)decoratorFactory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentCache getCache() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cache == null) {
                CacheLayoutBuilder layout = new CacheLayoutBuilder().withBuildScope(this.gradle.getRootProject());
                this.cache = (PersistentCache)this.cacheRepository.cache("taskArtifacts").withLayout(layout).withDisplayName("task artifact state cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.Exclusive)).open();
            }
            return this.cache;
        }
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(final String cacheName, final Class<K> keyType, final Serializer<V> valueSerializer) {
        Factory<PersistentIndexedCache> factory = new Factory<PersistentIndexedCache>(){

            public PersistentIndexedCache create() {
                final File cacheFile = DefaultTaskArtifactStateCacheAccess.this.cacheFile(cacheName);
                PersistentIndexedCacheParameters parameters = new PersistentIndexedCacheParameters<Object, Object>(cacheFile, keyType, valueSerializer).cacheDecorator(new Transformer<MultiProcessSafePersistentIndexedCache<Object, Object>, MultiProcessSafePersistentIndexedCache<Object, Object>>(){

                    public MultiProcessSafePersistentIndexedCache<Object, Object> transform(MultiProcessSafePersistentIndexedCache<Object, Object> original) {
                        return DefaultTaskArtifactStateCacheAccess.this.inMemoryDecorator.withMemoryCaching(cacheFile, original);
                    }
                });
                return DefaultTaskArtifactStateCacheAccess.this.getCache().createCache(parameters);
            }
        };
        return new LazyCreationProxy<PersistentIndexedCache>(PersistentIndexedCache.class, factory).getSource();
    }

    private File cacheFile(String cacheName) {
        return new File(this.getCache().getBaseDir(), cacheName + ".bin");
    }

    @Override
    public <T> T useCache(String operationDisplayName, Factory<? extends T> action) {
        return this.getCache().useCache(operationDisplayName, action);
    }

    @Override
    public void useCache(String operationDisplayName, Runnable action) {
        this.getCache().useCache(operationDisplayName, action);
    }

    @Override
    public void longRunningOperation(String operationDisplayName, Runnable action) {
        this.getCache().longRunningOperation(operationDisplayName, action);
    }
}

