/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import org.gradle.api.Action;
import org.gradle.api.InvalidActionClosureException;
import org.gradle.util.Configurable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureBackedAction<T>
implements Action<T> {
    private final Closure closure;
    private final boolean configureableAware;
    private final int resolveStrategy;

    public ClosureBackedAction(Closure closure) {
        this(closure, 1, true);
    }

    public ClosureBackedAction(Closure closure, int resolveStrategy) {
        this(closure, resolveStrategy, false);
    }

    public ClosureBackedAction(Closure closure, int resolveStrategy, boolean configureableAware) {
        this.closure = closure;
        this.configureableAware = configureableAware;
        this.resolveStrategy = resolveStrategy;
    }

    public void execute(T delegate) {
        block7: {
            if (this.closure == null) {
                return;
            }
            try {
                if (this.configureableAware && delegate instanceof Configurable) {
                    ((Configurable)delegate).configure(this.closure);
                } else {
                    Closure copy = (Closure)this.closure.clone();
                    copy.setResolveStrategy(this.resolveStrategy);
                    copy.setDelegate(delegate);
                    if (copy.getMaximumNumberOfParameters() == 0) {
                        copy.call();
                    } else {
                        copy.call(delegate);
                    }
                }
            }
            catch (MissingMethodException e) {
                if (!e.getType().equals(this.closure.getClass()) || !e.getMethod().equals("doCall")) break block7;
                throw new InvalidActionClosureException(this.closure, delegate);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClosureBackedAction that = (ClosureBackedAction)o;
        if (this.configureableAware != that.configureableAware) {
            return false;
        }
        if (this.resolveStrategy != that.resolveStrategy) {
            return false;
        }
        return this.closure.equals(that.closure);
    }

    public int hashCode() {
        int result = this.closure.hashCode();
        result = 31 * result + (this.configureableAware ? 1 : 0);
        result = 31 * result + this.resolveStrategy;
        return result;
    }
}

