/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.gradle.internal.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecationLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeprecationLogger.class);
    private static final Set<String> PLUGINS = Collections.synchronizedSet(new HashSet());
    private static final Set<String> TASKS = Collections.synchronizedSet(new HashSet());
    private static final Set<String> METHODS = Collections.synchronizedSet(new HashSet());
    private static final Set<String> DYNAMIC_PROPERTIES = Collections.synchronizedSet(new HashSet());
    private static final Set<String> PROPERTIES = Collections.synchronizedSet(new HashSet());
    private static final Set<String> NAMED_PARAMETERS = Collections.synchronizedSet(new HashSet());
    private static final ThreadLocal<Boolean> ENABLED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private static final ThreadLocal<Boolean> LOG_TRACE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    public static final String ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME = "org.gradle.deprecation.trace";

    public static void reset() {
        PLUGINS.clear();
        METHODS.clear();
        PROPERTIES.clear();
        NAMED_PARAMETERS.clear();
        DYNAMIC_PROPERTIES.clear();
    }

    public static void nagUserOfReplacedPlugin(String pluginName, String replacement) {
        if (DeprecationLogger.isEnabled() && PLUGINS.add(pluginName)) {
            LOGGER.warn(String.format("The %s plugin has been deprecated and will be removed in the next version of Gradle. Please use the %s plugin instead.", pluginName, replacement));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedTask(String taskName, String replacement) {
        if (DeprecationLogger.isEnabled() && TASKS.add(taskName)) {
            LOGGER.warn(String.format("The %s task has been deprecated and will be removed in the next version of Gradle. Please use the %s instead.", taskName, replacement));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedMethod(String methodName, String replacement) {
        if (DeprecationLogger.isEnabled() && METHODS.add(methodName)) {
            LOGGER.warn(String.format("The %s method has been deprecated and will be removed in the next version of Gradle. Please use the %s method instead.", methodName, replacement));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedProperty(String propertyName, String replacement) {
        if (DeprecationLogger.isEnabled() && PROPERTIES.add(propertyName)) {
            LOGGER.warn(String.format("The %s property has been deprecated and will be removed in the next version of Gradle. Please use the %s property instead.", propertyName, replacement));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName) {
        if (DeprecationLogger.isEnabled() && METHODS.add(methodName)) {
            LOGGER.warn(String.format("The %s method has been deprecated and will be removed in the next version of Gradle.", methodName));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfDiscontinuedProperty(String propertyName, String advice) {
        if (DeprecationLogger.isEnabled() && PROPERTIES.add(propertyName)) {
            LOGGER.warn(String.format("The %s property has been deprecated and will be removed in the next version of Gradle. %s", propertyName, advice));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedNamedParameter(String parameterName, String replacement) {
        if (DeprecationLogger.isEnabled() && NAMED_PARAMETERS.add(parameterName)) {
            LOGGER.warn(String.format("The %s named parameter has been deprecated and will be removed in the next version of Gradle. Please use the %s named parameter instead.", parameterName, replacement));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserWith(String message) {
        if (DeprecationLogger.isEnabled() && METHODS.add(message)) {
            LOGGER.warn(message);
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T whileDisabled(Factory<T> factory) {
        ENABLED.set(false);
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            ENABLED.set(true);
        }
    }

    private static boolean isTraceLoggingEnabled() {
        return Boolean.getBoolean(ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME) || LOG_TRACE.get() != false;
    }

    private static void logTraceIfNecessary() {
        if (DeprecationLogger.isTraceLoggingEnabled()) {
            StackTraceElement[] stack;
            for (StackTraceElement frame : stack = StackTraceUtils.sanitize((Throwable)new Exception()).getStackTrace()) {
                if (frame.getClassName().startsWith(DeprecationLogger.class.getName())) continue;
                LOGGER.warn("    {}", (Object)frame.toString());
            }
        }
    }

    private static boolean isEnabled() {
        return ENABLED.get();
    }

    public static void setLogTrace(boolean flag) {
        LOG_TRACE.set(flag);
    }

    public static void nagUserAboutDynamicProperty(String propertyName, Object target, Object value) {
        if (!DeprecationLogger.isEnabled()) {
            return;
        }
        DeprecationLogger.nagUserWith("Dynamic properties are deprecated: http://gradle.org/docs/current/dsl/org.gradle.api.plugins.ExtraPropertiesExtension.html");
        String propertyWithClass = target.getClass().getName() + "." + propertyName;
        if (DYNAMIC_PROPERTIES.add(propertyWithClass)) {
            String propertyWithTarget = String.format("\"%s\" on \"%s\"", propertyName, target);
            String theValue = value == null ? "null" : StringUtils.abbreviate((String)value.toString(), (int)25);
            DeprecationLogger.nagUserWith(String.format("Deprecated dynamic property: %s, value: \"%s\".", propertyWithTarget, theValue));
        } else {
            DeprecationLogger.nagUserWith(String.format("Deprecated dynamic property \"%s\" created in multiple locations.", propertyName));
        }
    }
}

