/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.internal.ArgumentsSplitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmOptions {
    private static final Pattern SYS_PROP_PATTERN = Pattern.compile("-D(.+?)=(.*)");
    private static final Pattern DEFAULT_ENCODING_PATTERN = Pattern.compile("-Dfile\\Q.\\Eencoding=(.*)");
    private static final Pattern NO_ARG_SYS_PROP_PATTERN = Pattern.compile("-D([^=]+)");
    private static final Pattern MIN_HEAP_PATTERN = Pattern.compile("-Xms(.+)");
    private static final Pattern MAX_HEAP_PATTERN = Pattern.compile("-Xmx(.+)");
    private static final Pattern BOOTSTRAP_PATTERN = Pattern.compile("-Xbootclasspath:(.+)");
    private static final String FILE_ENCODING_KEY = "file.encoding";
    private final List<Object> extraJvmArgs = new ArrayList<Object>();
    private final Map<String, Object> systemProperties = new TreeMap<String, Object>();
    private DefaultConfigurableFileCollection bootstrapClasspath;
    private String minHeapSize;
    private String maxHeapSize;
    private boolean assertionsEnabled;
    private boolean debug;
    private String defaultCharacterEncoding;

    public JvmOptions(FileResolver resolver) {
        this.bootstrapClasspath = new DefaultConfigurableFileCollection(resolver, null, new Object[0]);
    }

    public List<String> getAllJvmArgs() {
        LinkedList<String> args = new LinkedList<String>();
        for (Map.Entry<String, Object> entry : this.getSystemProperties().entrySet()) {
            if (entry.getValue() != null) {
                args.add(String.format("-D%s=%s", entry.getKey(), entry.getValue().toString()));
                continue;
            }
            args.add(String.format("-D%s", entry.getKey()));
        }
        args.addAll(this.getAllImmutableJvmArgs());
        return args;
    }

    public List<String> getAllImmutableJvmArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getJvmArgs());
        args.addAll(this.getManagedJvmArgs());
        return args;
    }

    public List<String> getManagedJvmArgs() {
        FileCollection bootstrapClasspath;
        ArrayList<String> args = new ArrayList<String>();
        if (this.minHeapSize != null) {
            args.add(String.format("-Xms%s", this.minHeapSize));
        }
        if (this.maxHeapSize != null) {
            args.add(String.format("-Xmx%s", this.maxHeapSize));
        }
        if (!(bootstrapClasspath = this.getBootstrapClasspath()).isEmpty()) {
            args.add(String.format("-Xbootclasspath:%s", bootstrapClasspath.getAsPath()));
        }
        this.addDefaultEncodingJvmArg(args);
        if (this.assertionsEnabled) {
            args.add("-ea");
        }
        if (this.debug) {
            args.add("-Xdebug");
            args.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005");
        }
        return args;
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        this.systemProperties.clear();
        this.minHeapSize = null;
        this.maxHeapSize = null;
        this.extraJvmArgs.clear();
        this.assertionsEnabled = false;
        this.jvmArgs(arguments);
    }

    public List<String> getJvmArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object extraJvmArg : this.extraJvmArgs) {
            args.add(extraJvmArg.toString());
        }
        return args;
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.extraJvmArgs.clear();
        this.jvmArgs(arguments);
    }

    public void jvmArgs(Iterable<?> arguments) {
        for (Object argument : arguments) {
            String argStr = argument.toString();
            Matcher matcher = DEFAULT_ENCODING_PATTERN.matcher(argStr);
            if (matcher.matches()) {
                this.defaultCharacterEncoding = matcher.group(1);
                continue;
            }
            matcher = SYS_PROP_PATTERN.matcher(argStr);
            if (matcher.matches()) {
                this.systemProperties.put(matcher.group(1), matcher.group(2));
                continue;
            }
            matcher = NO_ARG_SYS_PROP_PATTERN.matcher(argStr);
            if (matcher.matches()) {
                this.systemProperties.put(matcher.group(1), "");
                continue;
            }
            matcher = MIN_HEAP_PATTERN.matcher(argStr);
            if (matcher.matches()) {
                this.minHeapSize = matcher.group(1);
                continue;
            }
            matcher = MAX_HEAP_PATTERN.matcher(argStr);
            if (matcher.matches()) {
                this.maxHeapSize = matcher.group(1);
                continue;
            }
            matcher = BOOTSTRAP_PATTERN.matcher(argStr);
            if (matcher.matches()) {
                this.setBootstrapClasspath(matcher.group(1).split(Pattern.quote(File.pathSeparator)));
                continue;
            }
            if (argStr.equals("-ea") || argStr.equals("-enableassertions")) {
                this.assertionsEnabled = true;
                continue;
            }
            if (argStr.equals("-da") || argStr.equals("-disableassertions")) {
                this.assertionsEnabled = false;
                continue;
            }
            this.extraJvmArgs.add(argument);
        }
        boolean xdebugFound = false;
        boolean xrunjdwpFound = false;
        HashSet<Object> matches = new HashSet<Object>();
        for (Object extraJvmArg : this.extraJvmArgs) {
            if (extraJvmArg.toString().equals("-Xdebug")) {
                xdebugFound = true;
                matches.add(extraJvmArg);
                continue;
            }
            if (!extraJvmArg.toString().equals("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005")) continue;
            xrunjdwpFound = true;
            matches.add(extraJvmArg);
        }
        if (xdebugFound && xrunjdwpFound) {
            this.debug = true;
            this.extraJvmArgs.removeAll(matches);
        } else {
            this.debug = false;
        }
    }

    public void jvmArgs(Object ... arguments) {
        this.jvmArgs(Arrays.asList(arguments));
    }

    public Map<String, Object> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.systemProperties.clear();
        this.systemProperties(properties);
    }

    public void systemProperties(Map<String, ?> properties) {
        Object fileEncoding = properties.remove(FILE_ENCODING_KEY);
        if (fileEncoding != null) {
            this.defaultCharacterEncoding = fileEncoding.toString();
        }
        this.systemProperties.putAll(properties);
    }

    public void systemProperty(String name, Object value) {
        if (name.equals(FILE_ENCODING_KEY)) {
            this.defaultCharacterEncoding = value.toString();
        } else {
            this.systemProperties.put(name, value);
        }
    }

    public FileCollection getBootstrapClasspath() {
        return this.bootstrapClasspath;
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.bootstrapClasspath.setFrom(classpath);
    }

    public void setBootstrapClasspath(Object ... classpath) {
        this.bootstrapClasspath.setFrom(classpath);
    }

    public void bootstrapClasspath(Object ... classpath) {
        this.bootstrapClasspath.from(classpath);
    }

    public String getMinHeapSize() {
        return this.minHeapSize;
    }

    public void setMinHeapSize(String heapSize) {
        this.minHeapSize = heapSize;
    }

    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String heapSize) {
        this.maxHeapSize = heapSize;
    }

    public String getDefaultCharacterEncoding() {
        return this.defaultCharacterEncoding;
    }

    public String getEffectiveDefaultCharacterEncoding() {
        if (this.defaultCharacterEncoding != null) {
            return this.defaultCharacterEncoding;
        }
        return Charset.defaultCharset().name();
    }

    private void addDefaultEncodingJvmArg(List<String> jvmArgs) {
        jvmArgs.add(String.format("-Dfile.encoding=%s", this.getEffectiveDefaultCharacterEncoding()));
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.defaultCharacterEncoding = defaultCharacterEncoding;
    }

    public boolean getEnableAssertions() {
        return this.assertionsEnabled;
    }

    public void setEnableAssertions(boolean enabled) {
        this.assertionsEnabled = enabled;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean enabled) {
        this.debug = enabled;
    }

    public void copyTo(JavaForkOptions target) {
        target.setJvmArgs(this.extraJvmArgs);
        target.setSystemProperties(this.systemProperties);
        target.setMinHeapSize(this.minHeapSize);
        target.setMaxHeapSize(this.maxHeapSize);
        target.setBootstrapClasspath(this.bootstrapClasspath);
        target.setEnableAssertions(this.assertionsEnabled);
        target.setDebug(this.debug);
        target.setDefaultCharacterEncoding(this.defaultCharacterEncoding);
    }

    public static List<String> fromString(String input) {
        return ArgumentsSplitter.split(input);
    }
}

