/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging;

import org.gradle.StartParameter;
import org.gradle.cli.CommandLineConverter;
import org.gradle.internal.Factory;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.nativeplatform.NoOpTerminalDetector;
import org.gradle.internal.nativeplatform.TerminalDetector;
import org.gradle.internal.nativeplatform.jna.JnaBootPathConfigurer;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.logging.internal.DefaultLoggingConfigurer;
import org.gradle.logging.internal.DefaultLoggingManagerFactory;
import org.gradle.logging.internal.DefaultProgressLoggerFactory;
import org.gradle.logging.internal.DefaultStdErrLoggingSystem;
import org.gradle.logging.internal.DefaultStdOutLoggingSystem;
import org.gradle.logging.internal.DefaultStyledTextOutputFactory;
import org.gradle.logging.internal.EmbeddedLoggingManagerFactory;
import org.gradle.logging.internal.JavaUtilLoggingConfigurer;
import org.gradle.logging.internal.LoggingCommandLineConverter;
import org.gradle.logging.internal.LoggingSystem;
import org.gradle.logging.internal.NoOpLoggingSystem;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.OutputEventRenderer;
import org.gradle.logging.internal.ProgressLoggingBridge;
import org.gradle.logging.internal.StdErrLoggingSystem;
import org.gradle.logging.internal.StdOutLoggingSystem;
import org.gradle.logging.internal.TerminalDetectorFactory;
import org.gradle.logging.internal.TextStreamOutputEventListener;
import org.gradle.logging.internal.logback.LogbackLoggingConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingServiceRegistry
extends DefaultServiceRegistry {
    private TextStreamOutputEventListener stdoutListener;
    private final boolean detectConsole;
    private final boolean isEmbedded;

    LoggingServiceRegistry() {
        this(true, false);
    }

    LoggingServiceRegistry(boolean detectConsole, boolean isEmbedded) {
        this.detectConsole = detectConsole;
        this.isEmbedded = isEmbedded;
        this.stdoutListener = new TextStreamOutputEventListener((OutputEventListener)this.get(OutputEventListener.class));
    }

    public static LoggingServiceRegistry newCommandLineProcessLogging() {
        return new LoggingServiceRegistry(true, false);
    }

    public static LoggingServiceRegistry newChildProcessLogging() {
        return new LoggingServiceRegistry(false, false);
    }

    public static LoggingServiceRegistry newEmbeddableLogging() {
        return new LoggingServiceRegistry(false, true);
    }

    protected CommandLineConverter<LoggingConfiguration> createCommandLineConverter() {
        return new LoggingCommandLineConverter();
    }

    protected TimeProvider createTimeProvider() {
        return new TrueTimeProvider();
    }

    protected StdOutLoggingSystem createStdOutLoggingSystem() {
        if (this.isEmbedded) {
            return new NoOpLoggingSystem();
        }
        return new DefaultStdOutLoggingSystem(this.stdoutListener, (TimeProvider)this.get(TimeProvider.class));
    }

    protected StyledTextOutputFactory createStyledTextOutputFactory() {
        return new DefaultStyledTextOutputFactory(this.stdoutListener, (TimeProvider)this.get(TimeProvider.class));
    }

    protected StdErrLoggingSystem createStdErrLoggingSystem() {
        if (this.isEmbedded) {
            return new NoOpLoggingSystem();
        }
        TextStreamOutputEventListener listener = new TextStreamOutputEventListener((OutputEventListener)this.get(OutputEventListener.class));
        return new DefaultStdErrLoggingSystem(listener, (TimeProvider)this.get(TimeProvider.class));
    }

    protected ProgressLoggerFactory createProgressLoggerFactory() {
        return new DefaultProgressLoggerFactory(new ProgressLoggingBridge((OutputEventListener)this.get(OutputEventListener.class)), (TimeProvider)this.get(TimeProvider.class));
    }

    protected Factory<LoggingManagerInternal> createLoggingManagerFactory() {
        OutputEventRenderer renderer = (OutputEventRenderer)this.get(OutputEventRenderer.class);
        if (!this.isEmbedded) {
            DefaultLoggingConfigurer compositeConfigurer = new DefaultLoggingConfigurer(renderer);
            compositeConfigurer.add(new LogbackLoggingConfigurer(renderer));
            compositeConfigurer.add(new JavaUtilLoggingConfigurer());
            return new DefaultLoggingManagerFactory(compositeConfigurer, renderer, this.getStdOutLoggingSystem(), this.getStdErrLoggingSystem());
        }
        return new EmbeddedLoggingManagerFactory(renderer);
    }

    private LoggingSystem getStdErrLoggingSystem() {
        return (LoggingSystem)this.get(StdErrLoggingSystem.class);
    }

    private LoggingSystem getStdOutLoggingSystem() {
        return (LoggingSystem)this.get(StdOutLoggingSystem.class);
    }

    protected OutputEventRenderer createOutputEventRenderer() {
        NoOpTerminalDetector terminalDetector;
        if (this.detectConsole) {
            StartParameter startParameter = new StartParameter();
            JnaBootPathConfigurer jnaConfigurer = new JnaBootPathConfigurer(startParameter.getGradleUserHomeDir());
            terminalDetector = new TerminalDetectorFactory().create(jnaConfigurer);
        } else {
            terminalDetector = new NoOpTerminalDetector();
        }
        return new OutputEventRenderer((TerminalDetector)terminalDetector).addStandardOutputAndError();
    }
}

