/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.TaskFailureHandler;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.listener.ListenerManager;
import org.gradle.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskGraphExecuter
implements TaskGraphExecuter {
    private static Logger logger = LoggerFactory.getLogger(DefaultTaskGraphExecuter.class);
    private final ListenerBroadcast<TaskExecutionGraphListener> graphListeners;
    private final ListenerBroadcast<TaskExecutionListener> taskListeners;
    private final Map<Task, TaskInfo> executionPlan = new LinkedHashMap<Task, TaskInfo>();
    private boolean populated;
    private Spec<? super Task> filter = Specs.satisfyAll();
    private TaskFailureHandler failureHandler = new TaskFailureHandler(){

        public void onTaskFailure(Task task) {
            task.getState().rethrowFailure();
        }
    };

    public DefaultTaskGraphExecuter(ListenerManager listenerManager) {
        this.graphListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionGraphListener.class);
        this.taskListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionListener.class);
    }

    @Override
    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    @Override
    public void addTasks(Iterable<? extends Task> tasks) {
        assert (tasks != null);
        Clock clock = new Clock();
        TreeSet<Task> sortedTasks = new TreeSet<Task>();
        for (Task task : tasks) {
            sortedTasks.add(task);
        }
        this.fillDag(sortedTasks);
        this.populated = true;
        logger.debug("Timing: Creating the DAG took " + clock.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Clock clock = new Clock();
        this.graphListeners.getSource().graphPopulated(this);
        try {
            this.doExecute(this.executionPlan.values());
            logger.debug("Timing: Executing the DAG took " + clock.getTime());
        }
        finally {
            this.executionPlan.clear();
        }
    }

    public void execute(Iterable<? extends Task> tasks) {
        this.addTasks(tasks);
        this.execute();
    }

    private void fillDag(Collection<? extends Task> tasks) {
        HashSet<Task> visiting = new HashSet<Task>();
        ArrayList<? extends Task> queue = new ArrayList<Task>();
        queue.addAll(tasks);
        CachingTaskDependencyResolveContext context = new CachingTaskDependencyResolveContext();
        while (!queue.isEmpty()) {
            Task task = (Task)queue.get(0);
            if (!this.filter.isSatisfiedBy(task)) {
                queue.remove(0);
                continue;
            }
            if (this.executionPlan.containsKey(task)) {
                queue.remove(0);
                continue;
            }
            if (visiting.add(task)) {
                TreeSet dependsOnTasks = new TreeSet(Collections.reverseOrder());
                dependsOnTasks.addAll(context.getDependencies(task));
                for (Task task2 : dependsOnTasks) {
                    if (visiting.contains(task2)) {
                        throw new CircularReferenceException(String.format("Circular dependency between tasks. Cycle includes [%s, %s].", task, task2));
                    }
                    queue.add(0, task2);
                }
                continue;
            }
            queue.remove(0);
            visiting.remove(task);
            HashSet<TaskInfo> dependencies = new HashSet<TaskInfo>();
            for (Task task3 : context.getDependencies(task)) {
                TaskInfo dependencyInfo = this.executionPlan.get(task3);
                if (dependencyInfo == null) continue;
                dependencies.add(dependencyInfo);
            }
            this.executionPlan.put(task, new TaskInfo((TaskInternal)task, dependencies));
        }
    }

    @Override
    public void addTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.add(listener);
    }

    @Override
    public void removeTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.remove(listener);
    }

    @Override
    public void whenReady(Closure closure) {
        this.graphListeners.add("graphPopulated", closure);
    }

    @Override
    public void addTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.add(listener);
    }

    @Override
    public void removeTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.remove(listener);
    }

    @Override
    public void beforeTask(Closure closure) {
        this.taskListeners.add("beforeExecute", closure);
    }

    @Override
    public void afterTask(Closure closure) {
        this.taskListeners.add("afterExecute", closure);
    }

    @Override
    public void useFailureHandler(TaskFailureHandler handler) {
        this.failureHandler = handler;
    }

    private void doExecute(Iterable<? extends TaskInfo> tasks) {
        for (TaskInfo taskInfo : tasks) {
            this.executeTask(taskInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(TaskInfo taskInfo) {
        TaskInternal task = taskInfo.task;
        for (TaskInfo dependency : taskInfo.dependencies) {
            if (dependency.executed) continue;
            return;
        }
        this.taskListeners.getSource().beforeExecute(task);
        try {
            task.executeWithoutThrowingTaskFailure();
            if (task.getState().getFailure() != null) {
                this.failureHandler.onTaskFailure(task);
            } else {
                taskInfo.executed = true;
            }
        }
        finally {
            this.taskListeners.getSource().afterExecute(task, task.getState());
        }
    }

    @Override
    public boolean hasTask(Task task) {
        this.assertPopulated();
        return this.executionPlan.containsKey(task);
    }

    @Override
    public boolean hasTask(String path) {
        this.assertPopulated();
        assert (path != null && path.length() > 0);
        for (Task task : this.getAllTasks()) {
            if (!task.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Task> getAllTasks() {
        this.assertPopulated();
        return new ArrayList<Task>(this.executionPlan.keySet());
    }

    private void assertPopulated() {
        if (!this.populated) {
            throw new IllegalStateException("Task information is not available, as this task execution graph has not been populated.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskInfo {
        private final TaskInternal task;
        private final Set<TaskInfo> dependencies;
        private boolean executed;

        private TaskInfo(TaskInternal task, Set<TaskInfo> dependencies) {
            this.task = task;
            this.dependencies = dependencies;
        }
    }
}

