/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDependencies2TaskResolver
implements Action<Project> {
    private static Logger logger = LoggerFactory.getLogger(ProjectDependencies2TaskResolver.class);

    public void execute(Project project) {
        for (Project dependsOnProject : project.getDependsOnProjects()) {
            logger.debug("Checking task dependencies for project: {} dependsOn: {}", (Object)project, (Object)dependsOnProject);
            for (Task task : project.getTasks()) {
                String taskName = task.getName();
                Task dependentTask = (Task)dependsOnProject.getTasks().findByName(taskName);
                if (dependentTask == null) continue;
                logger.debug("Setting task dependencies for task: {}", (Object)taskName);
                task.dependsOn(dependentTask);
            }
        }
    }
}

