/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.gradle.CacheUsage;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistentDirectoryCache
extends DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPersistentDirectoryCache.class);
    private final File propertiesFile;
    private final Properties properties = new Properties();
    private final CacheUsage cacheUsage;
    private final Action<? super PersistentCache> initAction;
    private final CacheValidator validator;
    private boolean didRebuild;

    public DefaultPersistentDirectoryCache(File dir, String displayName, CacheUsage cacheUsage, CacheValidator validator, Map<String, ?> properties, FileLockManager.LockMode lockMode, Action<? super PersistentCache> initAction, FileLockManager lockManager) {
        super(dir, displayName, lockMode, lockManager);
        if (lockMode == FileLockManager.LockMode.None) {
            throw new UnsupportedOperationException("Locking mode None is not supported.");
        }
        this.validator = validator;
        this.cacheUsage = cacheUsage;
        this.initAction = initAction;
        this.propertiesFile = new File(dir, "cache.properties");
        this.properties.putAll(properties);
    }

    @Override
    protected File getLockTarget() {
        return this.propertiesFile;
    }

    @Override
    protected void init() throws IOException {
        boolean valid = this.determineIfCacheIsValid(this.getLock());
        int tries = 3;
        while (!valid) {
            if (--tries < 0) {
                throw new CacheOpenException(String.format("Failed to init valid cache for %s", this));
            }
            this.withExclusiveLock(new Action<FileLock>(){

                public void execute(final FileLock fileLock) {
                    boolean exclusiveLockValid;
                    try {
                        exclusiveLockValid = DefaultPersistentDirectoryCache.this.determineIfCacheIsValid(fileLock);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    if (!exclusiveLockValid) {
                        fileLock.writeFile(new Runnable(){

                            public void run() {
                                DefaultPersistentDirectoryCache.this.buildCacheDir((Action<? super PersistentCache>)DefaultPersistentDirectoryCache.this.initAction, fileLock);
                            }
                        });
                    }
                }
            });
            valid = this.determineIfCacheIsValid(this.getLock());
        }
    }

    private void buildCacheDir(Action<? super PersistentCache> initAction, FileLock fileLock) {
        for (File file : this.getBaseDir().listFiles()) {
            if (fileLock.isLockFile(file) || file.equals(this.propertiesFile)) continue;
            GFileUtils.forceDelete(file);
        }
        if (initAction != null) {
            initAction.execute((Object)this);
        }
        GUtil.saveProperties(this.properties, this.propertiesFile);
        this.didRebuild = true;
    }

    protected boolean determineIfCacheIsValid(FileLock lock) throws IOException {
        if (!this.didRebuild) {
            if (this.cacheUsage != CacheUsage.ON) {
                LOGGER.debug("Invalidating {} as cache usage is set to rebuild.", (Object)this);
                return false;
            }
            if (this.validator != null && !this.validator.isValid()) {
                LOGGER.debug("Invalidating {} as cache validator return false.", (Object)this);
                return false;
            }
        }
        if (!lock.getUnlockedCleanly()) {
            LOGGER.debug("Invalidating {} as it was not closed cleanly.", (Object)this);
            return false;
        }
        Properties currentProperties = GUtil.loadProperties(this.propertiesFile);
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            if (entry.getValue().toString().equals(currentProperties.getProperty(entry.getKey().toString()))) continue;
            LOGGER.debug("Invalidating {} as cache property {} has changed value.", (Object)this, entry.getKey());
            return false;
        }
        return true;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

