/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.cache.CacheAccess;
import org.gradle.cache.DefaultSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.FileAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultCacheAccess
implements CacheAccess {
    private final String cacheDiplayName;
    private final File lockFile;
    private final FileLockManager lockManager;
    private final FileAccess fileAccess = new UnitOfWorkFileAccess();
    private final Set<MultiProcessSafePersistentIndexedCache<?, ?>> caches = new HashSet();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private Thread owner;
    private FileLockManager.LockMode lockMode;
    private FileLock fileLock;
    private boolean started;
    private final List<String> operationStack = new ArrayList<String>();

    public DefaultCacheAccess(String cacheDisplayName, File lockFile, FileLockManager lockManager) {
        this.cacheDiplayName = cacheDisplayName;
        this.lockFile = lockFile;
        this.lockManager = lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(FileLockManager.LockMode lockMode) {
        this.lock.lock();
        try {
            if (this.owner != null) {
                throw new IllegalStateException(String.format("Cannot open the %s, as it is already in use.", this.cacheDiplayName));
            }
            this.lockMode = lockMode;
            if (lockMode == FileLockManager.LockMode.None) {
                return;
            }
            this.started = true;
            this.fileLock = this.lockManager.lock(this.lockFile, lockMode, this.cacheDiplayName);
            this.lockCache(String.format("Access %s", this.cacheDiplayName));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block7: {
            this.lock.lock();
            try {
                for (MultiProcessSafePersistentIndexedCache<?, ?> cache : this.caches) {
                    cache.close();
                }
                this.operationStack.clear();
                this.started = false;
                this.lockMode = null;
                this.owner = null;
                if (this.fileLock == null) break block7;
                try {
                    this.fileLock.close();
                }
                finally {
                    this.fileLock = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public FileLock getFileLock() {
        return this.fileLock;
    }

    @Override
    public void useCache(String operationDisplayName, final Runnable action) {
        this.useCache(operationDisplayName, new Factory<Object>(){

            public Object create() {
                action.run();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T useCache(String operationDisplayName, Factory<? extends T> action) {
        if (this.lockMode == FileLockManager.LockMode.Shared) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        this.lockCache(operationDisplayName);
        try {
            Object object;
            block8: {
                boolean wasStarted = this.onStartWork();
                try {
                    object = action.create();
                    if (!wasStarted) break block8;
                    this.onEndWork();
                }
                catch (Throwable throwable) {
                    if (wasStarted) {
                        this.onEndWork();
                    }
                    throw throwable;
                }
            }
            return (T)object;
        }
        finally {
            this.unlockCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockCache(String operationDisplayName) {
        this.lock.lock();
        try {
            while (this.owner != null && this.owner != Thread.currentThread()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            this.owner = Thread.currentThread();
            this.operationStack.add(0, operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockCache() {
        this.lock.lock();
        try {
            this.operationStack.remove(0);
            if (this.operationStack.isEmpty()) {
                this.owner = null;
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T longRunningOperation(String operationDisplayName, Factory<? extends T> action) {
        this.startLongRunningOperation();
        try {
            Object object;
            block7: {
                boolean wasEnded = this.onEndWork();
                try {
                    object = action.create();
                    if (!wasEnded) break block7;
                    this.onStartWork();
                }
                catch (Throwable throwable) {
                    if (wasEnded) {
                        this.onStartWork();
                    }
                    throw throwable;
                }
            }
            return (T)object;
        }
        finally {
            this.endLongRunningOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLongRunningOperation() {
        this.lock.lock();
        try {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException(String.format("Cannot start long running operation, as the %s has not been locked.", this.cacheDiplayName));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void endLongRunningOperation() {
    }

    @Override
    public void longRunningOperation(String operationDisplayName, final Runnable action) {
        this.longRunningOperation(operationDisplayName, new Factory<Object>(){

            public Object create() {
                action.run();
                return null;
            }
        });
    }

    public <K, V> PersistentIndexedCache<K, V> newCache(File cacheFile, Class<K> keyType, Class<V> valueType) {
        return this.newCache(cacheFile, keyType, new DefaultSerializer(valueType.getClassLoader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> PersistentIndexedCache<K, V> newCache(final File cacheFile, final Class<K> keyType, final Serializer<V> valueSerializer) {
        Factory indexedCacheFactory = new Factory<BTreePersistentIndexedCache<K, V>>(){

            public BTreePersistentIndexedCache<K, V> create() {
                return DefaultCacheAccess.this.doCreateCache(cacheFile, new DefaultSerializer(keyType.getClassLoader()), valueSerializer);
            }
        };
        MultiProcessSafePersistentIndexedCache indexedCache = new MultiProcessSafePersistentIndexedCache(indexedCacheFactory, this.fileAccess);
        this.lock.lock();
        try {
            this.caches.add(indexedCache);
            if (this.started) {
                indexedCache.onStartWork(this.operationStack.get(0));
            }
        }
        finally {
            this.lock.unlock();
        }
        return indexedCache;
    }

    <K, V> BTreePersistentIndexedCache<K, V> doCreateCache(File cacheFile, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new BTreePersistentIndexedCache<K, V>(cacheFile, keySerializer, valueSerializer);
    }

    private boolean onStartWork() {
        if (this.started) {
            return false;
        }
        this.started = true;
        for (MultiProcessSafePersistentIndexedCache<?, ?> cache : this.caches) {
            cache.onStartWork(this.operationStack.get(0));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onEndWork() {
        if (!this.started) {
            return false;
        }
        try {
            for (MultiProcessSafePersistentIndexedCache<?, ?> cache : this.caches) {
                cache.onEndWork();
            }
            if (this.fileLock != null) {
                this.fileLock.close();
            }
        }
        finally {
            this.started = false;
            this.fileLock = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock getLock() {
        this.lock.lock();
        try {
            if (Thread.currentThread() != this.owner || !this.started) {
                throw new IllegalStateException(String.format("The %s has not been locked.", this.cacheDiplayName));
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.fileLock == null) {
            this.fileLock = this.lockManager.lock(this.lockFile, FileLockManager.LockMode.Exclusive, this.cacheDiplayName, this.operationStack.get(0));
        }
        return this.fileLock;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnitOfWorkFileAccess
    extends AbstractFileAccess {
        private UnitOfWorkFileAccess() {
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException {
            return DefaultCacheAccess.this.getLock().readFile(action);
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().updateFile(action);
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().writeFile(action);
        }
    }
}

