/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskReportRenderer
extends TextReportRenderer {
    private boolean currentProjectHasTasks;
    private boolean currentProjectHasRules;
    private boolean hasContent;
    private boolean detail;

    @Override
    public void startProject(Project project) {
        this.currentProjectHasTasks = false;
        this.currentProjectHasRules = false;
        this.hasContent = false;
        this.detail = false;
        super.startProject(project);
    }

    @Override
    protected String createHeader(Project project) {
        String header = super.createHeader(project);
        return "All tasks runnable from " + StringUtils.uncapitalize((String)header);
    }

    public void showDetail(boolean detail) {
        this.detail = detail;
    }

    public void addDefaultTasks(List<String> defaultTaskNames) {
        if (defaultTaskNames.size() > 0) {
            this.getTextOutput().formatln("Default tasks: %s", GUtil.join(defaultTaskNames, ", "));
            this.hasContent = true;
        }
    }

    public void startTaskGroup(String taskGroup) {
        if (!GUtil.isTrue(taskGroup)) {
            this.addSubheading("Tasks");
        } else {
            this.addSubheading(StringUtils.capitalize((String)taskGroup) + " tasks");
        }
        this.currentProjectHasTasks = true;
    }

    public void addTask(TaskDetails task) {
        this.writeTask(task, "");
    }

    public void addChildTask(TaskDetails task) {
        if (this.detail) {
            this.writeTask(task, "    ");
        }
    }

    private void writeTask(TaskDetails task, String prefix) {
        this.getTextOutput().text(prefix);
        this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text(task.getPath());
        if (GUtil.isTrue(task.getDescription())) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Description).format(" - %s", task.getDescription());
        }
        if (this.detail) {
            TreeSet<Path> sortedDependencies = new TreeSet<Path>();
            for (TaskDetails dependency : task.getDependencies()) {
                sortedDependencies.add(dependency.getPath());
            }
            if (sortedDependencies.size() > 0) {
                this.getTextOutput().withStyle(StyledTextOutput.Style.Info).format(" [%s]", GUtil.join(sortedDependencies, ", "));
            }
        }
        this.getTextOutput().println();
    }

    private void addSubheading(String header) {
        if (this.hasContent) {
            this.getTextOutput().println();
        }
        this.hasContent = true;
        this.writeSubheading(header);
    }

    public void completeTasks() {
        if (!this.currentProjectHasTasks) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println("No tasks");
            this.hasContent = true;
        }
    }

    public void addRule(Rule rule) {
        if (!this.currentProjectHasRules) {
            this.addSubheading("Rules");
        }
        this.getTextOutput().println(GUtil.elvis(rule.getDescription(), ""));
        this.currentProjectHasRules = true;
    }

    @Override
    public void complete() throws IOException {
        if (!this.detail) {
            this.getTextOutput().println();
            this.getTextOutput().text("To see all tasks and more detail, run with ").style(StyledTextOutput.Style.UserInput).text("--all.");
            this.getTextOutput().println();
        }
        super.complete();
    }
}

