/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.GraphRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiReportRenderer
extends TextReportRenderer
implements DependencyReportRenderer {
    private boolean hasConfigs;
    private boolean hasCyclicDependencies;
    private GraphRenderer renderer;

    @Override
    public void startProject(Project project) {
        super.startProject(project);
        this.hasConfigs = false;
        this.hasCyclicDependencies = false;
    }

    @Override
    public void completeProject(Project project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println("No configurations");
        }
        super.completeProject(project);
    }

    @Override
    public void startConfiguration(final Configuration configuration) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.renderer.visit((Action<? super StyledTextOutput>)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                AsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text(configuration.getName());
                AsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text(AsciiReportRenderer.this.getDescription(configuration));
            }
        }, true);
    }

    private String getDescription(Configuration configuration) {
        return GUtil.isTrue(configuration.getDescription()) ? " - " + configuration.getDescription() : "";
    }

    @Override
    public void completeConfiguration(Configuration configuration) {
    }

    @Override
    public void render(ResolvedConfiguration resolvedConfiguration) throws IOException {
        Set<MergedResolvedDependency> mergedRoots = this.mergeChildren(resolvedConfiguration.getFirstLevelModuleDependencies());
        if (mergedRoots.isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).text("No dependencies");
            this.getTextOutput().println();
            return;
        }
        this.renderChildren(mergedRoots, new HashSet<String>());
    }

    @Override
    public void complete() throws IOException {
        if (this.hasCyclicDependencies) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println("\n(*) - dependencies omitted (listed previously)");
        }
        super.complete();
    }

    private void render(final MergedResolvedDependency resolvedDependency, Set<String> visitedDependencyNames, boolean lastChild) {
        final boolean isFirstVisitOfDependencyInConfiguration = visitedDependencyNames.add(resolvedDependency.getName());
        if (!isFirstVisitOfDependencyInConfiguration) {
            this.hasCyclicDependencies = true;
        }
        this.renderer.visit((Action<? super StyledTextOutput>)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                AsciiReportRenderer.this.getTextOutput().text(resolvedDependency.getName());
                StyledTextOutput infoStyle = AsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Info);
                infoStyle.format(" [%s]", resolvedDependency.getConfiguration());
                if (!isFirstVisitOfDependencyInConfiguration) {
                    infoStyle.append(" (*)");
                }
            }
        }, lastChild);
        if (isFirstVisitOfDependencyInConfiguration) {
            this.renderChildren(this.mergeChildren(resolvedDependency.getChildren()), visitedDependencyNames);
        }
    }

    private void renderChildren(Set<MergedResolvedDependency> children, Set<String> visitedDependencyNames) {
        this.renderer.startChildren();
        ArrayList<MergedResolvedDependency> mergedChildren = new ArrayList<MergedResolvedDependency>(children);
        for (int i = 0; i < mergedChildren.size(); ++i) {
            MergedResolvedDependency dependency = (MergedResolvedDependency)mergedChildren.get(i);
            this.render(dependency, visitedDependencyNames, i == mergedChildren.size() - 1);
        }
        this.renderer.completeChildren();
    }

    private Set<MergedResolvedDependency> mergeChildren(Set<ResolvedDependency> children) {
        LinkedHashMap<String, LinkedHashSet<ResolvedDependency>> mergedGroups = new LinkedHashMap<String, LinkedHashSet<ResolvedDependency>>();
        for (ResolvedDependency child : children) {
            LinkedHashSet<ResolvedDependency> mergeGroup = (LinkedHashSet<ResolvedDependency>)mergedGroups.get(child.getName());
            if (mergeGroup == null) {
                mergeGroup = new LinkedHashSet<ResolvedDependency>();
                mergedGroups.put(child.getName(), mergeGroup);
            }
            mergeGroup.add(child);
        }
        LinkedHashSet<MergedResolvedDependency> mergedChildren = new LinkedHashSet<MergedResolvedDependency>();
        for (Set mergedGroup : mergedGroups.values()) {
            mergedChildren.add(new MergedResolvedDependency(mergedGroup));
        }
        return mergedChildren;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MergedResolvedDependency {
        private Set<ResolvedDependency> mergedResolvedDependencies = new LinkedHashSet<ResolvedDependency>();

        public MergedResolvedDependency(Set<ResolvedDependency> mergedResolvedDependencies) {
            assert (!mergedResolvedDependencies.isEmpty());
            this.mergedResolvedDependencies = mergedResolvedDependencies;
        }

        public String getName() {
            return this.mergedResolvedDependencies.iterator().next().getName();
        }

        public String getConfiguration() {
            String mergedConfiguration = "";
            for (ResolvedDependency mergedResolvedDependency : this.mergedResolvedDependencies) {
                mergedConfiguration = mergedConfiguration + mergedResolvedDependency.getConfiguration() + ",";
            }
            return mergedConfiguration.substring(0, mergedConfiguration.length() - 1);
        }

        public Set<ResolvedDependency> getChildren() {
            LinkedHashSet<ResolvedDependency> mergedChildren = new LinkedHashSet<ResolvedDependency>();
            for (ResolvedDependency mergedResolvedDependency : this.mergedResolvedDependencies) {
                mergedChildren.addAll(mergedResolvedDependency.getChildren());
            }
            return mergedChildren;
        }
    }
}

