/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations.parsers;

import java.util.Arrays;
import java.util.Collection;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.api.internal.notations.api.UnsupportedNotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeNotationParser<T>
implements NotationParser<T> {
    private final Collection<NotationParser<? extends T>> delegates;

    public CompositeNotationParser(NotationParser<? extends T> ... delegates) {
        this.delegates = Arrays.asList(delegates);
    }

    public CompositeNotationParser(Collection<NotationParser<? extends T>> delegates) {
        assert (delegates != null) : "delegates cannot be null!";
        this.delegates = delegates;
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        for (NotationParser<T> delegate : this.delegates) {
            delegate.describe(candidateFormats);
        }
    }

    @Override
    public T parseNotation(Object notation) {
        for (NotationParser<T> delegate : this.delegates) {
            try {
                return delegate.parseNotation(notation);
            }
            catch (UnsupportedNotationException e) {
            }
        }
        throw new UnsupportedNotationException(notation);
    }
}

