/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.internal.notations.api.NotationParser;
import org.gradle.api.internal.notations.parsers.CompositeNotationParser;
import org.gradle.api.internal.notations.parsers.ErrorHandlingNotationParser;
import org.gradle.api.internal.notations.parsers.FlatteningNotationParser;
import org.gradle.api.internal.notations.parsers.JustReturningParser;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotationParserBuilder<T> {
    private Class<T> resultingType;
    private String invalidNotationMessage;
    private Collection<NotationParser<? extends T>> notationParsers = new LinkedList<NotationParser<? extends T>>();

    public NotationParserBuilder<T> resultingType(Class<T> resultingType) {
        this.resultingType = resultingType;
        return this;
    }

    public NotationParserBuilder<T> parser(NotationParser<? extends T> parser) {
        this.notationParsers.add(parser);
        return this;
    }

    public NotationParserBuilder<T> invalidNotationMessage(String invalidNotationMessage) {
        this.invalidNotationMessage = invalidNotationMessage;
        return this;
    }

    public NotationParserBuilder<T> parsers(Iterable<? extends NotationParser<? extends T>> notationParsers) {
        GUtil.addToCollection(this.notationParsers, notationParsers);
        return this;
    }

    public NotationParser<Set<T>> toFlatteningComposite() {
        return this.wrapInErrorHandling(new FlatteningNotationParser<T>(this.create()));
    }

    public NotationParser<T> toComposite() {
        return this.wrapInErrorHandling(this.create());
    }

    private <S> NotationParser<S> wrapInErrorHandling(NotationParser<S> parser) {
        return new ErrorHandlingNotationParser<S>(this.resultingType.getSimpleName(), this.invalidNotationMessage, parser);
    }

    private CompositeNotationParser<T> create() {
        assert (this.resultingType != null) : "resultingType cannot be null";
        LinkedList composites = new LinkedList();
        composites.add(new JustReturningParser<T>(this.resultingType));
        composites.addAll(this.notationParsers);
        return new CompositeNotationParser(composites);
    }
}

