/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.pattern.PatternStep;
import org.gradle.api.internal.file.pattern.PatternStepFactory;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPatternMatcher
implements Spec<RelativePath> {
    private List<PatternStep> steps;
    private boolean partialMatchDirs;

    public DefaultPatternMatcher(boolean partialMatchDirs, boolean caseSensitive, String ... patternParts) {
        this.partialMatchDirs = partialMatchDirs;
        this.steps = new ArrayList<PatternStep>();
        this.compile(caseSensitive, patternParts);
    }

    private void compile(boolean caseSensitive, String[] parts) {
        if (parts.length > 0) {
            for (int i = 0; i < parts.length; ++i) {
                this.steps.add(PatternStepFactory.getStep(parts[i], i == parts.length - 1, caseSensitive));
            }
        }
    }

    @Override
    public boolean isSatisfiedBy(RelativePath pathToTest) {
        ListIterator<PatternStep> patternIt = this.steps.listIterator();
        ListIterator<String> testIt = pathToTest.segmentIterator();
        boolean seenGreedy = false;
        while (testIt.hasNext()) {
            String nextToTest = testIt.next();
            if (!patternIt.hasNext()) {
                return false;
            }
            PatternStep patternStep = patternIt.next();
            if (patternStep.isGreedy()) {
                seenGreedy = true;
                this.advancePatternStepToNextNonGreedy(patternIt);
                if (!patternIt.hasNext()) {
                    return true;
                }
                patternStep = patternIt.next();
                while (!patternStep.matches(nextToTest, !testIt.hasNext() && pathToTest.isFile()) || patternIt.hasNext() != testIt.hasNext() && !this.nextPatternIsGreedy(patternIt)) {
                    if (!testIt.hasNext()) {
                        return this.partialMatchDirs && !pathToTest.isFile();
                    }
                    nextToTest = testIt.next();
                }
                continue;
            }
            if (patternStep.matches(nextToTest, !testIt.hasNext() && pathToTest.isFile())) continue;
            if (seenGreedy) {
                this.rewindPatternStepToPreviousGreedy(patternIt);
                testIt.previous();
                continue;
            }
            return false;
        }
        if (!patternIt.hasNext()) {
            return true;
        }
        return this.isTerminatingMatch(pathToTest, patternIt);
    }

    private boolean nextPatternIsGreedy(ListIterator<PatternStep> patternIt) {
        boolean result = false;
        if (patternIt.hasNext()) {
            PatternStep next = patternIt.next();
            if (next.isGreedy() && !patternIt.hasNext()) {
                result = true;
            }
            patternIt.previous();
        }
        return result;
    }

    private boolean isTerminatingMatch(RelativePath pathToTest, ListIterator<PatternStep> patternIt) {
        PatternStep patternStep;
        if (patternIt.hasNext() && (patternStep = patternIt.next()).isGreedy() && !patternIt.hasNext()) {
            return true;
        }
        return !pathToTest.isFile() && this.partialMatchDirs;
    }

    private void advancePatternStepToNextNonGreedy(ListIterator<PatternStep> patternIt) {
        PatternStep next = null;
        while (patternIt.hasNext() && (next = patternIt.next()).isGreedy()) {
        }
        if (next != null && !next.isGreedy()) {
            patternIt.previous();
        }
    }

    private void rewindPatternStepToPreviousGreedy(ListIterator<PatternStep> patternIt) {
        PatternStep result = null;
        while (patternIt.hasPrevious()) {
            result = patternIt.previous();
            if (!result.isGreedy()) continue;
            return;
        }
        throw new IllegalStateException("PatternStep list iterator in non-greedy state when rewindToLastGreedy");
    }

    List<PatternStep> getStepsForTest() {
        return this.steps;
    }
}

