/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotter;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.UpToDateRule;
import org.gradle.util.ChangeListener;

public class InputFilesChangedUpToDateRule
implements UpToDateRule {
    private final FileSnapshotter inputFilesSnapshotter;

    public InputFilesChangedUpToDateRule(FileSnapshotter inputFilesSnapshotter) {
        this.inputFilesSnapshotter = inputFilesSnapshotter;
    }

    public UpToDateRule.TaskUpToDateState create(final TaskInternal task, final TaskExecution previousExecution, final TaskExecution currentExecution) {
        final FileCollectionSnapshot inputFilesSnapshot = this.inputFilesSnapshotter.snapshot(task.getInputs().getFiles());
        return new UpToDateRule.TaskUpToDateState(){

            @Override
            public void checkUpToDate(final Collection<String> messages) {
                if (previousExecution.getInputFilesSnapshot() == null) {
                    messages.add(String.format("Input file history is not available for %s.", task));
                    return;
                }
                inputFilesSnapshot.changesSince(previousExecution.getInputFilesSnapshot(), new ChangeListener<File>(){

                    @Override
                    public void added(File file) {
                        messages.add(String.format("Input file %s for %s added.", file, task));
                    }

                    @Override
                    public void removed(File file) {
                        messages.add(String.format("Input file %s for %s removed.", file, task));
                    }

                    @Override
                    public void changed(File file) {
                        messages.add(String.format("Input file %s for %s has changed.", file, task));
                    }
                });
            }

            @Override
            public void snapshotAfterTask() {
                currentExecution.setInputFilesSnapshot(inputFilesSnapshot);
            }
        };
    }
}

