/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.gradle.api.internal.changedetection.Hasher;
import org.gradle.api.internal.changedetection.TaskArtifactStateCacheAccess;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.messaging.serialize.Serializer;

public class CachingHasher
implements Hasher {
    private final PersistentIndexedCache<File, FileInfo> cache;
    private final Hasher hasher;
    private long timestamp;

    public CachingHasher(Hasher hasher, TaskArtifactStateCacheAccess cacheAccess) {
        this.hasher = hasher;
        this.cache = cacheAccess.createCache("fileHashes", File.class, FileInfo.class, new FileInfoSerializer());
    }

    public byte[] hash(File file) {
        FileInfo info = this.cache.get(file);
        long length = file.length();
        this.timestamp = file.lastModified();
        if (info != null && length == info.length && this.timestamp == info.timestamp) {
            return info.hash;
        }
        byte[] hash = this.hasher.hash(file);
        this.cache.put(file, new FileInfo(hash, length, this.timestamp));
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileInfoSerializer
    implements Serializer<FileInfo> {
        private FileInfoSerializer() {
        }

        public FileInfo read(InputStream instr) throws Exception {
            DataInputStream input = new DataInputStream(instr);
            int hashLength = input.readInt();
            byte[] hash = new byte[hashLength];
            input.readFully(hash);
            long timestamp = input.readLong();
            long length = input.readLong();
            return new FileInfo(hash, length, timestamp);
        }

        public void write(OutputStream outstr, FileInfo value) throws Exception {
            DataOutputStream output = new DataOutputStream(outstr);
            output.writeInt(value.hash.length);
            output.write(value.hash);
            output.writeLong(value.timestamp);
            output.writeLong(value.length);
            output.flush();
        }
    }

    public static class FileInfo
    implements Serializable {
        private final byte[] hash;
        private final long timestamp;
        private final long length;

        public FileInfo(byte[] hash, long length, long timestamp) {
            this.hash = hash;
            this.length = length;
            this.timestamp = timestamp;
        }
    }
}

