/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.DefaultArtifactRepositoryContainer;
import org.gradle.api.internal.artifacts.ResolverFactory;
import org.gradle.api.internal.artifacts.configurations.ResolverProvider;
import org.gradle.api.internal.artifacts.repositories.FixedResolverArtifactRepository;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryHandler
extends DefaultArtifactRepositoryContainer
implements RepositoryHandler,
ResolverProvider {
    public DefaultRepositoryHandler(ResolverFactory resolverFactory, Instantiator instantiator) {
        super(resolverFactory, instantiator);
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Action<? super FlatDirectoryArtifactRepository> action) {
        return this.addRepository(this.getResolverFactory().createFlatDirRepository(), action, "flatDir");
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Closure configureClosure) {
        return this.addRepository(this.getResolverFactory().createFlatDirRepository(), configureClosure, "flatDir");
    }

    @Override
    public FlatDirectoryArtifactRepository flatDir(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        if (modifiedArgs.containsKey("dirs")) {
            modifiedArgs.put("dirs", this.toList(modifiedArgs.get("dirs")));
        }
        return this.addRepository(this.getResolverFactory().createFlatDirRepository(), modifiedArgs, "flatDir");
    }

    @Override
    public MavenArtifactRepository mavenCentral() {
        return this.mavenCentral(Collections.emptyMap());
    }

    @Override
    public MavenArtifactRepository mavenCentral(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        if (modifiedArgs.containsKey("urls")) {
            DeprecationLogger.nagUserWith("The 'urls' property of the RepositoryHandler.mavenCentral() method is deprecated and will be removed in a future version of Gradle. You should use the 'artifactUrls' property to define additional artifact locations.");
            List<Object> urls = this.toList(modifiedArgs.remove("urls"));
            modifiedArgs.put("artifactUrls", urls);
        }
        return this.addRepository(this.getResolverFactory().createMavenCentralRepository(), modifiedArgs, "MavenRepo");
    }

    @Override
    public MavenArtifactRepository mavenLocal() {
        return this.addRepository(this.getResolverFactory().createMavenLocalRepository(), "MavenLocal");
    }

    @Override
    public DependencyResolver mavenRepo(Map<String, ?> args) {
        return this.mavenRepo(args, null);
    }

    @Override
    public DependencyResolver mavenRepo(Map<String, ?> args, Closure configClosure) {
        List<Object> urls;
        HashMap modifiedArgs = new HashMap(args);
        if (modifiedArgs.containsKey("urls") && !(urls = this.toList(modifiedArgs.remove("urls"))).isEmpty()) {
            DeprecationLogger.nagUserWith("The 'urls' property of the RepositoryHandler.mavenRepo() method is deprecated and will be removed in a future version of Gradle. You should use the 'url' property to define the core maven repository & the 'artifactUrls' property to define any additional artifact locations.");
            modifiedArgs.put("url", urls.get(0));
            List<Object> extraUrls = urls.subList(1, urls.size());
            modifiedArgs.put("artifactUrls", extraUrls);
        }
        MavenArtifactRepository repository = this.getResolverFactory().createMavenRepository();
        ConfigureUtil.configureByMap(modifiedArgs, repository);
        DependencyResolver resolver = this.toResolver(DependencyResolver.class, repository);
        ConfigureUtil.configure(configClosure, resolver);
        this.addRepository(new FixedResolverArtifactRepository(resolver), "maven");
        return resolver;
    }

    private List<Object> toList(Object object) {
        if (object instanceof List) {
            return (List)object;
        }
        if (object instanceof Iterable) {
            return Lists.newArrayList((Iterable)((Iterable)object));
        }
        return Collections.singletonList(object);
    }

    @Override
    public MavenArtifactRepository maven(Action<? super MavenArtifactRepository> action) {
        return this.addRepository(this.getResolverFactory().createMavenRepository(), action, "maven");
    }

    @Override
    public MavenArtifactRepository maven(Closure closure) {
        return this.addRepository(this.getResolverFactory().createMavenRepository(), closure, "maven");
    }

    @Override
    public IvyArtifactRepository ivy(Action<? super IvyArtifactRepository> action) {
        return this.addRepository(this.getResolverFactory().createIvyRepository(), action, "ivy");
    }

    @Override
    public IvyArtifactRepository ivy(Closure closure) {
        return this.addRepository(this.getResolverFactory().createIvyRepository(), closure, "ivy");
    }
}

