/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultResolutionStrategy;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.listener.ListenerManager;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration
extends AbstractFileCollection
implements ConfigurationInternal {
    private final String path;
    private final String name;
    private Configuration.Visibility visibility = Configuration.Visibility.PUBLIC;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private String description;
    private ConfigurationsProvider configurationsProvider;
    private final ArtifactDependencyResolver dependencyResolver;
    private final ListenerManager listenerManager;
    private final DependencyMetaDataProvider metaDataProvider;
    private final DefaultDependencySet dependencies;
    private final CompositeDomainObjectSet<Dependency> inheritedDependencies;
    private final DefaultDependencySet allDependencies;
    private final DefaultPublishArtifactSet artifacts;
    private final CompositeDomainObjectSet<PublishArtifact> inheritedArtifacts;
    private final DefaultPublishArtifactSet allArtifacts;
    private final ConfigurationResolvableDependencies resolvableDependencies = new ConfigurationResolvableDependencies();
    private final ListenerBroadcast<DependencyResolutionListener> resolutionListenerBroadcast;
    private Set<ExcludeRule> excludeRules = new LinkedHashSet<ExcludeRule>();
    private final Object lock = new Object();
    private Configuration.State state = Configuration.State.UNRESOLVED;
    private ResolvedConfiguration cachedResolvedConfiguration;
    private final DefaultResolutionStrategy resolutionStrategy;

    public DefaultConfiguration(String path, String name, ConfigurationsProvider configurationsProvider, ArtifactDependencyResolver dependencyResolver, ListenerManager listenerManager, DependencyMetaDataProvider metaDataProvider, DefaultResolutionStrategy resolutionStrategy) {
        this.path = path;
        this.name = name;
        this.configurationsProvider = configurationsProvider;
        this.dependencyResolver = dependencyResolver;
        this.listenerManager = listenerManager;
        this.metaDataProvider = metaDataProvider;
        assert (resolutionStrategy != null) : "Cannot create configuration with null resolutionStrategy";
        this.resolutionStrategy = resolutionStrategy;
        this.resolutionListenerBroadcast = listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        DefaultDomainObjectSet<Dependency> ownDependencies = new DefaultDomainObjectSet<Dependency>(Dependency.class);
        ownDependencies.beforeChange(new VetoContainerChangeAction());
        this.dependencies = new DefaultDependencySet(String.format("%s dependencies", this.getDisplayName()), ownDependencies);
        this.inheritedDependencies = new CompositeDomainObjectSet<Dependency>(Dependency.class, new DomainObjectCollection[]{ownDependencies});
        this.allDependencies = new DefaultDependencySet(String.format("%s all dependencies", this.getDisplayName()), this.inheritedDependencies);
        DefaultDomainObjectSet<PublishArtifact> ownArtifacts = new DefaultDomainObjectSet<PublishArtifact>(PublishArtifact.class);
        ownArtifacts.beforeChange(new VetoContainerChangeAction());
        this.artifacts = new DefaultPublishArtifactSet(String.format("%s artifacts", this.getDisplayName()), ownArtifacts);
        this.inheritedArtifacts = new CompositeDomainObjectSet<PublishArtifact>(PublishArtifact.class, new DomainObjectCollection[]{ownArtifacts});
        this.allArtifacts = new DefaultPublishArtifactSet(String.format("%s all artifacts", this.getDisplayName()), this.inheritedArtifacts);
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration.State getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    @Override
    public Module getModule() {
        return this.metaDataProvider.getModule();
    }

    @Override
    public boolean isVisible() {
        return this.visibility == Configuration.Visibility.PUBLIC;
    }

    @Override
    public Configuration setVisible(boolean visible) {
        this.throwExceptionIfNotInUnresolvedState();
        this.visibility = visible ? Configuration.Visibility.PUBLIC : Configuration.Visibility.PRIVATE;
        return this;
    }

    @Override
    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    @Override
    public Configuration setExtendsFrom(Set<Configuration> extendsFrom) {
        this.throwExceptionIfNotInUnresolvedState();
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedArtifacts.removeCollection(configuration.getAllArtifacts());
            this.inheritedDependencies.removeCollection(configuration.getAllDependencies());
        }
        this.extendsFrom = new HashSet<Configuration>();
        for (Configuration configuration : extendsFrom) {
            this.extendsFrom(configuration);
        }
        return this;
    }

    @Override
    public Configuration extendsFrom(Configuration ... extendsFrom) {
        this.throwExceptionIfNotInUnresolvedState();
        for (Configuration configuration : extendsFrom) {
            if (configuration.getHierarchy().contains(this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", this, configuration, configuration.getHierarchy()));
            }
            this.extendsFrom.add(configuration);
            this.inheritedArtifacts.addCollection(configuration.getAllArtifacts());
            this.inheritedDependencies.addCollection(configuration.getAllDependencies());
        }
        return this;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public Configuration setTransitive(boolean transitive) {
        this.throwExceptionIfNotInUnresolvedState();
        this.transitive = transitive;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Configuration setDescription(String description) {
        this.throwExceptionIfNotInUnresolvedState();
        this.description = description;
        return this;
    }

    @Override
    public Set<Configuration> getHierarchy() {
        Set<Configuration> result = WrapUtil.toLinkedSet(this);
        this.collectSuperConfigs(this, result);
        return result;
    }

    private void collectSuperConfigs(Configuration configuration, Set<Configuration> result) {
        for (Configuration superConfig : configuration.getExtendsFrom()) {
            if (result.contains(superConfig)) {
                result.remove(superConfig);
            }
            result.add(superConfig);
            this.collectSuperConfigs(superConfig, result);
        }
    }

    @Override
    public Set<Configuration> getAll() {
        return this.configurationsProvider.getAll();
    }

    @Override
    public Set<File> resolve() {
        return this.getFiles();
    }

    @Override
    public Set<File> getFiles() {
        return this.fileCollection(Specs.SATISFIES_ALL).getFiles();
    }

    @Override
    public Set<File> files(Dependency ... dependencies) {
        return this.fileCollection(dependencies).getFiles();
    }

    @Override
    public Set<File> files(Closure dependencySpecClosure) {
        return this.fileCollection(dependencySpecClosure).getFiles();
    }

    @Override
    public Set<File> files(Spec<? super Dependency> dependencySpec) {
        return this.fileCollection(dependencySpec).getFiles();
    }

    @Override
    public FileCollection fileCollection(Spec<? super Dependency> dependencySpec) {
        return new ConfigurationFileCollection(dependencySpec);
    }

    @Override
    public FileCollection fileCollection(Closure dependencySpecClosure) {
        return new ConfigurationFileCollection(dependencySpecClosure);
    }

    @Override
    public FileCollection fileCollection(Dependency ... dependencies) {
        return new ConfigurationFileCollection(WrapUtil.toLinkedSet(dependencies));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvedConfiguration getResolvedConfiguration() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == Configuration.State.UNRESOLVED) {
                DependencyResolutionListener broadcast = this.getDependencyResolutionBroadcast();
                ResolvableDependencies incoming = this.getIncoming();
                broadcast.beforeResolve(incoming);
                this.cachedResolvedConfiguration = this.dependencyResolver.resolve(this);
                this.state = this.cachedResolvedConfiguration.hasError() ? Configuration.State.RESOLVED_WITH_FAILURES : Configuration.State.RESOLVED;
                broadcast.afterResolve(incoming);
            }
            return this.cachedResolvedConfiguration;
        }
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.allDependencies.getBuildDependencies();
    }

    @Override
    public TaskDependency getTaskDependencyFromProjectDependency(final boolean useDependedOn, final String taskName) {
        return new AbstractTaskDependency(){

            public void resolve(TaskDependencyResolveContext context) {
                if (useDependedOn) {
                    this.addTaskDependenciesFromProjectsIDependOn(taskName, context);
                } else {
                    Project thisProject = context.getTask().getProject();
                    this.addTaskDependenciesFromProjectsDependingOnMe(thisProject, taskName, context);
                }
            }

            private void addTaskDependenciesFromProjectsIDependOn(String taskName2, TaskDependencyResolveContext context) {
                DomainObjectSet<ProjectDependency> projectDependencies = DefaultConfiguration.this.getAllDependencies().withType(ProjectDependency.class);
                for (ProjectDependency projectDependency : projectDependencies) {
                    Task nextTask = (Task)projectDependency.getDependencyProject().getTasks().findByName(taskName2);
                    if (nextTask == null) continue;
                    context.add(nextTask);
                }
            }

            private void addTaskDependenciesFromProjectsDependingOnMe(Project thisProject, String taskName2, TaskDependencyResolveContext context) {
                Set<Task> tasksWithName = thisProject.getRootProject().getTasksByName(taskName2, true);
                for (Task nextTask : tasksWithName) {
                    Configuration configuration = (Configuration)nextTask.getProject().getConfigurations().findByName(DefaultConfiguration.this.getName());
                    if (configuration == null || !DefaultConfiguration.doesConfigurationDependOnProject(configuration, thisProject)) continue;
                    context.add(nextTask);
                }
            }
        };
    }

    private static boolean doesConfigurationDependOnProject(Configuration configuration, Project project) {
        DomainObjectSet<ProjectDependency> projectDependencies = configuration.getAllDependencies().withType(ProjectDependency.class);
        for (ProjectDependency projectDependency : projectDependencies) {
            if (!projectDependency.getDependencyProject().equals(project)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DependencySet getDependencies() {
        return this.dependencies;
    }

    @Override
    public DependencySet getAllDependencies() {
        return this.allDependencies;
    }

    @Override
    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    @Override
    public PublishArtifactSet getAllArtifacts() {
        return this.allArtifacts;
    }

    @Override
    public Set<ExcludeRule> getExcludeRules() {
        return Collections.unmodifiableSet(this.excludeRules);
    }

    public void setExcludeRules(Set<ExcludeRule> excludeRules) {
        this.throwExceptionIfNotInUnresolvedState();
        this.excludeRules = excludeRules;
    }

    @Override
    public DefaultConfiguration exclude(Map<String, String> excludeRuleArgs) {
        this.throwExceptionIfNotInUnresolvedState();
        this.excludeRules.add(new DefaultExcludeRule(excludeRuleArgs.get("group"), excludeRuleArgs.get("module")));
        return this;
    }

    @Override
    public String getUploadTaskName() {
        return Configurations.uploadTaskName(this.getName());
    }

    @Override
    public String getDisplayName() {
        return String.format("configuration '%s'", this.path);
    }

    @Override
    public ResolvableDependencies getIncoming() {
        return this.resolvableDependencies;
    }

    @Override
    public Configuration copy() {
        return this.createCopy(this.getDependencies(), false);
    }

    @Override
    public Configuration copyRecursive() {
        return this.createCopy(this.getAllDependencies(), true);
    }

    @Override
    public Configuration copy(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter(this.getDependencies(), dependencySpec), false);
    }

    @Override
    public Configuration copyRecursive(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter(this.getAllDependencies(), dependencySpec), true);
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies, boolean recursive) {
        DetachedConfigurationsProvider configurationsProvider = new DetachedConfigurationsProvider();
        DefaultConfiguration copiedConfiguration = new DefaultConfiguration(this.path + "Copy", this.name + "Copy", configurationsProvider, this.dependencyResolver, this.listenerManager, this.metaDataProvider, this.resolutionStrategy);
        configurationsProvider.setTheOnlyConfiguration(copiedConfiguration);
        copiedConfiguration.visibility = this.visibility;
        copiedConfiguration.transitive = this.transitive;
        copiedConfiguration.description = this.description;
        copiedConfiguration.getArtifacts().addAll(this.getAllArtifacts());
        LinkedHashSet<Configuration> excludeRuleSources = new LinkedHashSet<Configuration>();
        excludeRuleSources.add(this);
        if (recursive) {
            excludeRuleSources.addAll(this.getHierarchy());
        }
        for (Configuration excludeRuleSource : excludeRuleSources) {
            for (ExcludeRule excludeRule : excludeRuleSource.getExcludeRules()) {
                copiedConfiguration.excludeRules.add(new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
            }
        }
        DependencySet copiedDependencies = copiedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            copiedDependencies.add(dependency.copy());
        }
        return copiedConfiguration;
    }

    @Override
    public Configuration copy(Closure dependencySpec) {
        return this.copy(Specs.convertClosureToSpec(dependencySpec));
    }

    @Override
    public Configuration copyRecursive(Closure dependencySpec) {
        return this.copyRecursive(Specs.convertClosureToSpec(dependencySpec));
    }

    @Override
    public DependencyResolutionListener getDependencyResolutionBroadcast() {
        return this.resolutionListenerBroadcast.getSource();
    }

    @Override
    public DefaultResolutionStrategy getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    @Override
    public Configuration resolutionStrategy(Closure closure) {
        ConfigureUtil.configure(closure, this.resolutionStrategy);
        return this;
    }

    private void throwExceptionIfNotInUnresolvedState() {
        if (this.getState() != Configuration.State.UNRESOLVED) {
            throw new InvalidUserDataException("You can't change a configuration which is not in unresolved state!");
        }
    }

    public String dump() {
        StringBuilder reply = new StringBuilder();
        reply.append("\nConfiguration:");
        reply.append("  class='" + this.getClass() + "'");
        reply.append("  name='" + this.getName() + "'");
        reply.append("  hashcode='" + this.hashCode() + "'");
        reply.append("\nLocal Dependencies:");
        if (this.getDependencies().size() > 0) {
            for (Dependency d : this.getDependencies()) {
                reply.append("\n   " + d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nLocal Artifacts:");
        if (this.getArtifacts().size() > 0) {
            for (PublishArtifact a : this.getArtifacts()) {
                reply.append("\n   " + a);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Dependencies:");
        if (this.getAllDependencies().size() > 0) {
            for (Dependency d : this.getAllDependencies()) {
                reply.append("\n   " + d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Artifacts:");
        if (this.getAllArtifacts().size() > 0) {
            for (PublishArtifact a : this.getAllArtifacts()) {
                reply.append("\n   " + a);
            }
        } else {
            reply.append("\n   none");
        }
        return reply.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigurationResolvableDependencies
    implements ResolvableDependencies {
        private ConfigurationResolvableDependencies() {
        }

        @Override
        public String getName() {
            return DefaultConfiguration.this.name;
        }

        @Override
        public String getPath() {
            return DefaultConfiguration.this.path;
        }

        public String toString() {
            return String.format("dependencies '%s'", DefaultConfiguration.this.path);
        }

        @Override
        public FileCollection getFiles() {
            return DefaultConfiguration.this.fileCollection(Specs.satisfyAll());
        }

        @Override
        public DependencySet getDependencies() {
            return DefaultConfiguration.this.getAllDependencies();
        }

        @Override
        public void beforeResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add("beforeResolve", action);
        }

        @Override
        public void beforeResolve(Closure action) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add("beforeResolve", action);
        }

        @Override
        public void afterResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add("afterResolve", action);
        }

        @Override
        public void afterResolve(Closure action) {
            DefaultConfiguration.this.resolutionListenerBroadcast.add("afterResolve", action);
        }
    }

    private class VetoContainerChangeAction
    implements Runnable {
        private VetoContainerChangeAction() {
        }

        public void run() {
            DefaultConfiguration.this.throwExceptionIfNotInUnresolvedState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConfigurationFileCollection
    extends AbstractFileCollection {
        private Spec<? super Dependency> dependencySpec;

        private ConfigurationFileCollection(Spec<? super Dependency> dependencySpec) {
            this.dependencySpec = dependencySpec;
        }

        public ConfigurationFileCollection(Closure dependencySpecClosure) {
            this.dependencySpec = Specs.convertClosureToSpec(dependencySpecClosure);
        }

        public ConfigurationFileCollection(final Set<Dependency> dependencies) {
            this.dependencySpec = new Spec<Dependency>(){

                @Override
                public boolean isSatisfiedBy(Dependency element) {
                    return dependencies.contains(element);
                }
            };
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return DefaultConfiguration.this.getBuildDependencies();
        }

        public Spec<? super Dependency> getDependencySpec() {
            return this.dependencySpec;
        }

        @Override
        public String getDisplayName() {
            return String.format("%s dependencies", DefaultConfiguration.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<File> getFiles() {
            Object object = DefaultConfiguration.this.lock;
            synchronized (object) {
                ResolvedConfiguration resolvedConfiguration = DefaultConfiguration.this.getResolvedConfiguration();
                if (DefaultConfiguration.this.getState() == Configuration.State.RESOLVED_WITH_FAILURES) {
                    resolvedConfiguration.rethrowFailure();
                }
                return resolvedConfiguration.getFiles(this.dependencySpec);
            }
        }
    }
}

