/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import org.gradle.api.internal.GradleDistributionLocator;

public class DocumentationRegistry {
    private final GradleDistributionLocator locator;

    public DocumentationRegistry(GradleDistributionLocator locator) {
        this.locator = locator;
    }

    public String getDocumentationFor(String id) {
        if (this.locator.getGradleHome() != null) {
            File pageLocation = new File(this.locator.getGradleHome(), String.format("docs/userguide/%s.html", id));
            File userGuideLocation = new File(this.locator.getGradleHome(), "docs/userguide/userguide.html");
            if (pageLocation.isFile() && userGuideLocation.isFile()) {
                return pageLocation.getAbsolutePath();
            }
            if (!pageLocation.isFile() && userGuideLocation.isFile()) {
                throw new IllegalArgumentException(String.format("User guide page '%s' not found.", pageLocation));
            }
            if (pageLocation.isFile() && !userGuideLocation.isFile()) {
                throw new IllegalArgumentException(String.format("User guide page '%s' not found.", userGuideLocation));
            }
        }
        return String.format("http://gradle.org/docs/current/userguide/%s.html", id);
    }
}

