/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.DynamicObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeDynamicObject
extends AbstractDynamicObject {
    private DynamicObject[] objects = new DynamicObject[0];
    private DynamicObject[] updateObjects = new DynamicObject[0];

    protected void setObjects(DynamicObject ... objects) {
        this.objects = objects;
        this.updateObjects = objects;
    }

    protected void setObjectsForUpdate(DynamicObject ... objects) {
        this.updateObjects = objects;
    }

    @Override
    public boolean hasProperty(String name) {
        for (DynamicObject object : this.objects) {
            if (!object.hasProperty(name)) continue;
            return true;
        }
        return super.hasProperty(name);
    }

    @Override
    public Object getProperty(String name) throws MissingPropertyException {
        for (DynamicObject object : this.objects) {
            if (!object.hasProperty(name)) continue;
            return object.getProperty(name);
        }
        return super.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws MissingPropertyException {
        for (DynamicObject object : this.updateObjects) {
            if (!object.hasProperty(name)) continue;
            object.setProperty(name, value);
            return;
        }
        this.updateObjects[this.updateObjects.length - 1].setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = this.objects.length - 1; i >= 0; --i) {
            DynamicObject object = this.objects[i];
            properties.putAll(object.getProperties());
        }
        properties.put("properties", properties);
        return properties;
    }

    @Override
    public boolean hasMethod(String name, Object ... arguments) {
        for (DynamicObject object : this.objects) {
            if (!object.hasMethod(name, arguments)) continue;
            return true;
        }
        return super.hasMethod(name, arguments);
    }

    @Override
    public Object invokeMethod(String name, Object ... arguments) throws MissingMethodException {
        Object property;
        for (DynamicObject object : this.objects) {
            if (!object.hasMethod(name, arguments)) continue;
            return object.invokeMethod(name, arguments);
        }
        if (this.hasProperty(name) && (property = this.getProperty(name)) instanceof Closure) {
            Closure closure = (Closure)property;
            closure.setResolveStrategy(1);
            return closure.call(arguments);
        }
        return super.invokeMethod(name, arguments);
    }
}

