/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

public class TaskExecutionLogger
implements TaskExecutionListener {
    private ProgressLogger currentTask;
    private final ProgressLoggerFactory progressLoggerFactory;

    public TaskExecutionLogger(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
    }

    public void beforeExecute(Task task) {
        assert (this.currentTask == null);
        this.currentTask = this.progressLoggerFactory.newOperation(TaskExecutionLogger.class);
        String displayName = this.getDisplayName(task);
        this.currentTask.setDescription(String.format("Execute %s", displayName));
        this.currentTask.setShortDescription(displayName);
        this.currentTask.setLoggingHeader(displayName);
        this.currentTask.started();
    }

    public void afterExecute(Task task, TaskState state) {
        this.currentTask.completed(state.getSkipMessage());
        this.currentTask = null;
    }

    private String getDisplayName(Task task) {
        Gradle build = task.getProject().getGradle();
        if (build.getParent() == null) {
            return task.getPath();
        }
        return ":" + build.getRootProject().getName() + task.getPath();
    }
}

