/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import org.codehaus.groovy.runtime.StackTraceUtils;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.LocationAwareException;
import org.gradle.api.logging.LogLevel;
import org.gradle.execution.TaskSelectionException;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.ShowStacktrace;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.logging.internal.BufferingStyledTextOutput;
import org.gradle.logging.internal.LinePrefixingStyledTextOutput;
import org.gradle.util.GUtil;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildExceptionReporter
extends BuildAdapter
implements Action<Throwable> {
    private final StyledTextOutputFactory textOutputFactory;
    private final LoggingConfiguration loggingConfiguration;
    private final BuildClientMetaData clientMetaData;

    public BuildExceptionReporter(StyledTextOutputFactory textOutputFactory, LoggingConfiguration loggingConfiguration, BuildClientMetaData clientMetaData) {
        this.textOutputFactory = textOutputFactory;
        this.loggingConfiguration = loggingConfiguration;
        this.clientMetaData = clientMetaData;
    }

    @Override
    public void buildFinished(BuildResult result) {
        Throwable failure = result.getFailure();
        if (failure == null) {
            return;
        }
        this.execute(failure);
    }

    public void execute(Throwable failure) {
        FailureDetails details = new FailureDetails(failure);
        if (failure instanceof GradleException) {
            this.reportBuildFailure((GradleException)failure, details);
        } else {
            this.reportInternalError(details);
        }
        this.write(details);
    }

    protected void write(FailureDetails details) {
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).text("FAILURE: ");
        details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
        if (details.location.getHasContent()) {
            output.println().println();
            output.println("* Where:");
            details.location.writeTo(output);
        }
        if (details.details.getHasContent()) {
            output.println().println();
            output.println("* What went wrong:");
            details.details.writeTo(output);
        }
        if (details.resolution.getHasContent()) {
            output.println().println();
            output.println("* Try:");
            details.resolution.writeTo(output);
        }
        Throwable exception = null;
        switch (details.exceptionStyle) {
            case NONE: {
                break;
            }
            case SANITIZED: {
                exception = StackTraceUtils.deepSanitize((Throwable)details.failure);
                break;
            }
            case FULL: {
                exception = details.failure;
            }
        }
        if (exception != null) {
            output.println().println();
            output.println("* Exception is:");
            output.exception(exception);
        }
        output.println();
    }

    public void reportInternalError(FailureDetails details) {
        details.summary.text("Build aborted because of an internal error.");
        details.details.text("Build aborted because of an unexpected internal error. Please file an issue at: http://forums.gradle.org.");
        if (this.loggingConfiguration.getLogLevel() != LogLevel.DEBUG) {
            details.resolution.text("Run with ");
            details.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "debug");
            details.resolution.text(" option to get additional debug info.");
            details.exceptionStyle = ExceptionStyle.FULL;
        }
    }

    private void reportBuildFailure(GradleException failure, FailureDetails details) {
        if (this.loggingConfiguration.getShowStacktrace() == ShowStacktrace.ALWAYS || this.loggingConfiguration.getLogLevel() == LogLevel.DEBUG) {
            details.exceptionStyle = ExceptionStyle.SANITIZED;
        }
        if (this.loggingConfiguration.getShowStacktrace() == ShowStacktrace.ALWAYS_FULL) {
            details.exceptionStyle = ExceptionStyle.FULL;
        }
        if (failure instanceof TaskSelectionException) {
            this.formatTaskSelectionFailure((TaskSelectionException)failure, details);
        } else {
            this.formatGenericFailure(failure, details);
        }
    }

    private void formatTaskSelectionFailure(TaskSelectionException failure, FailureDetails details) {
        assert (failure.getCause() == null);
        details.summary.text("Could not determine which tasks to execute.");
        details.details.text(this.getMessage(failure));
        details.resolution.text("Run ");
        this.clientMetaData.describeCommand(details.resolution.withStyle(StyledTextOutput.Style.UserInput), "tasks");
        details.resolution.text(" to get a list of available tasks.");
    }

    private void formatGenericFailure(GradleException failure, final FailureDetails details) {
        details.summary.text("Build failed with an exception.");
        this.fillInFailureResolution(details);
        if (failure instanceof LocationAwareException) {
            final LocationAwareException scriptException = (LocationAwareException)failure;
            details.failure = scriptException.getCause();
            if (scriptException.getLocation() != null) {
                details.location.text(scriptException.getLocation());
            }
            scriptException.visitReportableCauses((TreeVisitor<? super Throwable>)new TreeVisitor<Throwable>(){
                int depth;

                @Override
                public void node(Throwable node) {
                    if (node == scriptException) {
                        details.details.text(scriptException.getOriginalMessage());
                    } else {
                        details.details.format("%n", new Object[0]);
                        StringBuilder prefix = new StringBuilder();
                        for (int i = 1; i < this.depth; ++i) {
                            prefix.append("   ");
                        }
                        details.details.text(prefix);
                        prefix.append("  ");
                        details.details.style(StyledTextOutput.Style.Info).text("> ").style(StyledTextOutput.Style.Normal);
                        LinePrefixingStyledTextOutput output = new LinePrefixingStyledTextOutput(details.details, prefix);
                        output.text(BuildExceptionReporter.this.getMessage(node));
                    }
                }

                @Override
                public void startChildren() {
                    ++this.depth;
                }

                @Override
                public void endChildren() {
                    --this.depth;
                }
            });
        } else {
            details.details.text(this.getMessage(failure));
        }
    }

    private void fillInFailureResolution(FailureDetails details) {
        if (details.exceptionStyle == ExceptionStyle.NONE) {
            details.resolution.text("Run with ");
            details.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "stacktrace");
            details.resolution.text(" option to get the stack trace. ");
        }
        if (this.loggingConfiguration.getLogLevel() != LogLevel.DEBUG) {
            details.resolution.text("Run with ");
            if (this.loggingConfiguration.getLogLevel() != LogLevel.INFO) {
                details.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "info");
                details.resolution.text(" or ");
            }
            details.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "debug");
            details.resolution.text(" option to get more log output.");
        }
    }

    private String getMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (GUtil.isTrue(message)) {
            return message;
        }
        return String.format("%s (no error message)", throwable.getClass().getName());
    }

    private static class FailureDetails {
        Throwable failure;
        final BufferingStyledTextOutput summary = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput details = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput location = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput resolution = new BufferingStyledTextOutput();
        ExceptionStyle exceptionStyle = ExceptionStyle.NONE;

        public FailureDetails(Throwable failure) {
            this.failure = failure;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExceptionStyle {
        NONE,
        SANITIZED,
        FULL;

    }
}

