/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.hash;

import java.math.BigInteger;

public class HashValue {
    private final BigInteger digest;

    public HashValue(byte[] byArray) {
        this.digest = new BigInteger(1, byArray);
    }

    public HashValue(String string) {
        this.digest = new BigInteger(string, 16);
    }

    public static HashValue parse(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new HashValue(HashValue.parseInput(string));
    }

    private static String parseInput(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim().toLowerCase();
        int n = string2.indexOf(32);
        if (n != -1) {
            String string3 = string2.substring(0, n);
            string2 = string3.startsWith("md") || string3.startsWith("sha") ? string2.substring(string2.lastIndexOf(32) + 1) : (string3.endsWith(":") ? string2.substring(n + 1).replace(" ", "") : string2.substring(0, n));
        }
        return string2;
    }

    public String asCompactString() {
        return this.digest.toString(32);
    }

    public String asHexString() {
        return this.digest.toString(16);
    }

    public byte[] asByteArray() {
        return this.digest.toByteArray();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HashValue)) {
            return false;
        }
        HashValue hashValue = (HashValue)object;
        return this.digest.equals(hashValue.digest);
    }

    public int hashCode() {
        return this.digest.hashCode();
    }
}

