/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.hash;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.UncheckedException;
import org.gradle.util.hash.HashValue;

public class HashUtil {
    public static HashValue createHash(String string, String string2) {
        MessageDigest messageDigest = HashUtil.createMessageDigest(string2);
        messageDigest.update(string.getBytes());
        return new HashValue(messageDigest.digest());
    }

    public static HashValue createHash(File file, String string) {
        try {
            return HashUtil.createHash(new FileInputStream(file), string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UncheckedIOException(fileNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashValue createHash(InputStream inputStream, String string) {
        MessageDigest messageDigest = HashUtil.createMessageDigest(string);
        try {
            byte[] byArray = new byte[4096];
            try {
                int n;
                while ((n = inputStream.read(byArray)) >= 0) {
                    messageDigest.update(byArray, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return new HashValue(messageDigest.digest());
    }

    private static MessageDigest createMessageDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw UncheckedException.throwAsUncheckedException((Throwable)noSuchAlgorithmException);
        }
    }

    public static String createCompactMD5(String string) {
        return HashUtil.createHash(string, "MD5").asCompactString();
    }

    public static HashValue sha1(byte[] byArray) {
        return HashUtil.createHash(new ByteArrayInputStream(byArray), "SHA1");
    }

    public static HashValue sha1(InputStream inputStream) {
        return HashUtil.createHash(inputStream, "SHA1");
    }

    public static HashValue sha1(File file) {
        return HashUtil.createHash(file, "SHA1");
    }
}

