/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapUtil {
    public static <T> Set<T> toSet(T ... TArray) {
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, TArray);
        return hashSet;
    }

    public static <T> DomainObjectSet<T> toDomainObjectSet(Class<T> clazz, T ... TArray) {
        return new DefaultDomainObjectSet<T>(clazz, WrapUtil.toSet(TArray));
    }

    public static <T> Set<T> toLinkedSet(T ... TArray) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Collections.addAll(linkedHashSet, TArray);
        return linkedHashSet;
    }

    public static <T> SortedSet<T> toSortedSet(T ... TArray) {
        TreeSet treeSet = new TreeSet();
        Collections.addAll(treeSet, TArray);
        return treeSet;
    }

    public static <T> SortedSet<T> toSortedSet(Comparator<T> comparator, T ... TArray) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        Collections.addAll(treeSet, TArray);
        return treeSet;
    }

    public static <T> List<T> toList(T ... TArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, TArray);
        return arrayList;
    }

    public static <T> List<T> toList(Iterable<? extends T> iterable) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : iterable) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <K, V> Map<K, V> toMap(K k, V v) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        hashMap.put(k, v);
        return hashMap;
    }

    public static <K, V> SortedMap<K, V> toSortedMap(K k, V v) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>();
        treeMap.put(k, v);
        return treeMap;
    }

    public static <K, V> Map<K, V> toLinkedMap(K k, V v) {
        LinkedHashMap<K, V> linkedHashMap = new LinkedHashMap<K, V>();
        linkedHashMap.put(k, v);
        return linkedHashMap;
    }

    public static Properties toProperties(String string, String string2) {
        Properties properties = new Properties();
        properties.setProperty(string, string2);
        return properties;
    }

    public static <T> T[] toArray(T ... TArray) {
        return TArray;
    }

    public static <T> Set<T> asSet(Collection<T> collection) {
        return new LinkedHashSet<T>(collection);
    }
}

